// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/Common/hctFilterCommon.h>

#include <ContentTools/Common/Filters/Common/hctBaseDll.h>

#include <Common/Base/System/hkBaseSystem.h>
#include <Common/Base/DebugUtil/MultiThreadCheck/hkMultiThreadCheck.h>
#include <Common/Base/Monitor/hkMonitorStream.h>
#include <Common/Base/Memory/Allocator/Malloc/hkMallocAllocator.h>

#include <Common/Base/Config/hkProductFeatures.h>

/*static*/ unsigned int  hctBaseDll::getCurrentDllVersion ()
{
    return HCT_CURRENT_VERSION;
}

hctBaseDll::hctBaseDll (HMODULE dllModule) : m_dllModule(dllModule)
{

}

/*virtual*/ HMODULE hctBaseDll::getDllModule() const
{
    return m_dllModule;
}

/*virtual*/ unsigned int hctBaseDll::getDllVersion() const
{
    return getCurrentDllVersion();
}

/*virtual*/ void hctBaseDll::initDll ( const hkMemoryInitUtil::SyncInfo& baseSystemInfo, hkError* errorStream )
{
    extern hkBool hkBaseSystemIsInitialized;
    if (baseSystemInfo.m_memoryRouter) // allow dummy init, so that all DLLs can be cached (incl Cloth dll children etc)
    {
        hkMemoryInitUtil::SyncInfo::syncLocalInitNodes(baseSystemInfo);

        hkBaseSystem::initNodes(&hkBaseSystem::InitNode::s_listHead);
        hkMonitorStream::init();

        if (errorStream)
        {
            hkError::replaceInstance(errorStream);
            errorStream->addReference();
        }

        HK_ON_DEBUG_MULTI_THREADING(hkMultiThreadCheck::staticInit(hkMallocAllocator::m_defaultMallocAllocator));

        hkProductFeatures::initialize();
        hkBaseSystemIsInitialized = true;
    }
}

/*virtual*/ bool hctBaseDll::isInitialized()
{
    extern hkBool hkBaseSystemIsInitialized;
    return hkBaseSystemIsInitialized;
}

/*virtual*/ void hctBaseDll::quitDll ()
{
    extern hkBool hkBaseSystemIsInitialized;
    if (hkBaseSystemIsInitialized)// allow dummy quit, so that all DLLs can be cached (incl Cloth dll children etc)
    {
        hkBaseSystem::quit();
    }
}

/*virtual*/ void hctBaseDll::initThread ( hkMemoryRouter* mem )
{
    if (mem)
    {
        hkBaseSystem::initThread( mem );
    }
    else
    {
        hkBaseSystem::quitThread();
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
