// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

    /// This class implements some methods used to populate and handle user interaction with a tree-view representation of the
    /// contents that is being processed. It is used by filters such as ViewXML and CreateSkeleton.
class hctTreeViewManager
{
    public:

            /// Constructor - takes a variant to use as the root of the tree, and an optional class registry.
        hctTreeViewManager( const hkReflect::Var* root ) : m_root(root) {}
        virtual ~hctTreeViewManager() {}

            /// Determines whether a specific class type should appear in the tree.
        virtual bool isViewable( const hkReflect::Var& variant ) = 0;

            /// Determines whether a specific class type should be 'selectable' in some dialogs.
        virtual bool isSelectable( const hkReflect::Var& variant ) { return isViewable( variant ); }

            /// Adds the root node to the specified tree control.
        void init( HWND treeWnd );

            /// Handles Win32 messages, especially the expansion of items in the tree.
        BOOL handleNotification( LPNMHDR n );

            /// Retrieves a variant structure for the currently selected tree item, if any.
        bool getSelectedVariant( struct hkReflect::Var& var );

    protected:

            /// Gets the index of a variant in the tree item <-> variant map,
            /// adding a new entry if it was not found.
        int getVariantIndex( const struct hkReflect::Var& var );

            /// Retrieves the name, the children and the index into the scene nodes bitmap,
            /// for any given variant.
        void getItemData( const struct hkReflect::Var& var, hkStringOld& name, hkArray< hkReflect::Var >& children, int& imageIndex );

            /// Adds a variant as a child of a tree item.
        void addItem( HTREEITEM parent, const struct hkReflect::Var& var );

        const hkReflect::Var* m_root;

        HWND m_treeWnd;
        hkArray< hkReflect::Var > m_variantMap;
};

    /// A class that implements a tree viewer with the default behavior, i.e. all class types in the tree are displayed
    /// and are selectable.
class hctDefaultTreeViewManager : public hctTreeViewManager
{
public:

    hctDefaultTreeViewManager( const hkReflect::Var* root ) : hctTreeViewManager( root ) {}

    /*virtual*/ bool isViewable( const hkReflect::Var& variant ) { return true; }
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
