// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/Common/hctFilterCommon.h>

#include <Common/Base/Container/String/hkUtf8.h>
#include <Common/Base/Reflect/Visitor/hkReflectVisitor.h>

#include <Common/SceneData/Graph/hkxNode.h>
#include <Common/SceneData/Skin/hkxSkinBinding.h>
#include <Common/SceneData/Mesh/hkxMesh.h>
#include <Common/SceneData/Mesh/hkxMeshSection.h>
#include <Common/SceneData/Mesh/hkxIndexBuffer.h>
#include <Common/SceneData/Mesh/hkxVertexBuffer.h>
#include <Common/SceneData/Material/hkxMaterial.h>
#include <Common/SceneData/Material/hkxTextureInplace.h>
#include <Common/SceneData/Material/hkxTextureFile.h>
#include <Common/SceneData/Light/hkxLight.h>
#include <Common/SceneData/Camera/hkxCamera.h>
#include <Common/SceneData/Attributes/hkxAttributeGroup.h>
#include <Common/SceneData/Environment/hkxEnvironment.h>


void hctTreeViewManager::init( HWND treeWnd )
{
    m_treeWnd = treeWnd;
    if( m_root )
    {
        addItem( TVI_ROOT, *m_root );
    }
}

BOOL hctTreeViewManager::handleNotification( LPNMHDR n )
{
    switch (n->code)
    {
    case TVN_ITEMEXPANDINGW:
        {
            LPNMTREEVIEWW treeViewNM = (LPNMTREEVIEWW)n;
            TVITEMW& tvParent = treeViewNM->itemNew; // hItem, state, and lParam are valid
            int varIndex = (int)tvParent.lParam;
            if( ( varIndex >= 0 ) && ( varIndex < m_variantMap.getSize() ) )
            {
                hkVariant& var = m_variantMap[varIndex];

                hkStringOld name;
                hkArray< hkVariant > children;
                int imageIndex;
                getItemData( var, name, children, imageIndex );

                if( (treeViewNM->action & TVE_EXPAND) && ( children.getSize() > 0 ) ) // expanding, we must add the children (if not added already)
                {
                    if ( TreeView_GetChild( m_treeWnd, tvParent.hItem ) == NULL )
                    {
                        for( int ci=0; ci<children.getSize(); ++ci )
                        {
                            HK_ASSERT_NO_MSG(0x41fb2b29, children[ci].getType());
                            addItem( tvParent.hItem, children[ci] );
                        }
                    }
                }

                return TRUE; // handled it
            }
        }
    }

    return FALSE;
}

bool hctTreeViewManager::getSelectedVariant( hkVariant& var )
{
    TVITEM tvi;
    tvi.hItem = TreeView_GetSelection( m_treeWnd );
    tvi.mask = TVIF_PARAM;
    TreeView_GetItem( m_treeWnd, &tvi );

    if ( ( tvi.lParam >= 0 ) && ( tvi.lParam < m_variantMap.getSize() ) )
    {
        int varIndex = (int)( tvi.lParam );
        var = m_variantMap[varIndex];
        return true;
    }

    var = hkReflect::Var();
    return false;
}



int hctTreeViewManager::getVariantIndex( const hkVariant& var )
{
    int numVars = m_variantMap.getSize();
    for( int vi=0; vi < numVars; ++vi )
    {
        if( m_variantMap[vi].getData() == var.getData() )
        {
            return vi;
        }
    }

    m_variantMap.expandOne() = var;
    return numVars;
}


template <typename T>
struct _DummyArray
{
    T* data;
    int size;
};

namespace
{
    struct TreeViewVisitor : public hkReflect::VarVisitor<TreeViewVisitor, void, hkStringOld&, hkArray< hkVariant >&>
    {
        void visit(const hkReflect::VoidVar&, hkStringOld&, hkArray<hkVariant>&) { HK_UNREACHABLE(0x4c28722b, "Void field found" ); }
        void visit(const hkReflect::OpaqueVar&, hkStringOld&, hkArray<hkVariant>&) { /* do nothing */ }
        void visit(const hkReflect::ValueVar&, hkStringOld&, hkArray<hkVariant>&) { /* do nothing */ }

        void visit(const hkReflect::PointerVar& ptrVar, hkStringOld& name, hkArray<hkVariant>& children)
        {
            if (hkReflect::Var tgt = ptrVar.getValue())
            {
                dispatch(tgt, name, children);
            }
        }

        void visit(const hkReflect::RecordVar& recVar, hkStringOld& name, hkArray<hkVariant>& children)
        {
            children.pushBack(recVar);
        }

        void visit(const hkReflect::StringVar& strVar, hkStringOld& name, hkArray<hkVariant>& children)
        {
            hkReflect::FieldDecl asField(strVar.getType());
            if ( asField && hkString::strCmp( asField.getName(), "name" ) == 0 )
            {
                name = strVar.getValue();
            }
        }

        void visit(const hkReflect::ArrayVar& conVar, hkStringOld& name, hkArray<hkVariant>& children)
        {
            for (hkReflect::VarIter varIt = conVar.begin(); varIt != conVar.end(); ++varIt)
            {
                hkStringOld dummy;
                dispatch(*varIt, dummy, children);
            }
        }
    };
}


void hctTreeViewManager::getItemData( const hkVariant& var, hkStringOld& name, hkArray< hkVariant >& children, int& imageIndex )
{
    name = "";
    children.clear();
    imageIndex = -1;

    for (hkReflect::DeclIter<hkReflect::FieldDecl> recIt(var.getType()); recIt.advance();)
    {
        TreeViewVisitor().dispatch(var[recIt.current()], name, children);
    }

    // use address if not named
    if( name.getLength() < 1 )
    {
        name.printf("%s @ 0x%x", var.getType()->getName(), var.getData());
    }

    // filter allowed types only
    for( int ci=children.getSize()-1; ci>=0; --ci )
    {
        if( !isViewable( children[ci])  )
        {
            children.removeAtAndCopy( ci );
        }
    }

    //
    // image index
    // NOTE that the image list must be setup by the filter itself
    //

    struct IconPair
    {
        const char* m_className;
        int m_iconIndex;
    };

    static IconPair iconPairs [] =
    {
        { "hkaAnimationContainer", 0 },
        { "hkaBoneAttachment", 1 },
        { "hkaBone", 2 },
        { "hkFxClothBodySubsystemCollection", 3 },
        { "hkFxPhysicsCollection", 4 },
        { "hkFxRigidBody", 5 },
        { "hkFxShape", 6 },
        { "hkxSkinBinding", 7 },
        { "hkaMeshBinding", 7 },
        { "hkpPhysicsData", 8 },
        { "hkpRigidBody", 9 },
        { "hkRootLevelContainer", 10 },
        { "hkaSkeleton", 11 },
        { "hkxCamera", 12 },
        { "hkxEnvironment", 13 },
        { "hkxLight", 14 },
        { "hkxMaterial", 15 },
        { "hkxMesh", 16 },
        { "hkxMeshSection", 17 },
        { "hkxNode", 18 },
        { "hkxScene", 19 },
        { "hkxAttributeGroup", 20 },

        { "hclClothData", 22 },
        { "hclSimClothData", 23 },
        { "hclSimClothPose", 24 },
        { "hclSimClothDataParticleData", 25},
        { "hclConstraintSet", 26 },
        { "hclOperator", 27 },
        { "hclClothState", 28 },
        { "hclTransformSetDefinition", 29},
        { "hclCollidable", 30},
        { "hclBufferDefinition", 31},
        { "hclClothContainer", 32},
        // { generic cloth icon , 33 }
        { "hclSimulateOperator", 34 },
        { "hclGatherAllVerticesOperator", 35 },
        { "hclGatherSomeVerticesOperator", 35 },
        { "hclCopyVerticesOperator", 35 },
        { "hclMeshMeshDeformOperator", 36 },
        { "hclRecalculateAllNormalsOperator", 37 },
        { "hclRecalculateSomeNormalsOperator", 37 },
        { "hclSkinOperator", 38 },
        { "hclBlendSomeVerticesOperator", 39 },
        { "hclStandardLinkConstraintSet", 40 },
        { "hclStretchLinkConstraintSet", 41 },
        { "hclHingeConstraintSet", 42 },
        { "hclBendLinkConstraintSet", 43 },
        { "hclLocalRangeConstraintSet", 44 },
        { "hclSphereShape", 45 },
        { "hclBoxShape", 46 },
        { "hclCapsuleShape", 47 },
        { "hclPlanarHeightField", 48 },
        { "hclCapsuleHeightField", 49 },
        { "hclConvexHeightField", 50 },
        { "hclPlane", 51 },

    };

    static int numIconPairs = sizeof(iconPairs) / sizeof(IconPair);

    bool iconFound = false;

    hkReflect::Var current = var;

    while (hkRootLevelContainer::NamedVariant* variant = current.dynCast<hkRootLevelContainer::NamedVariant>())
    {
        if( variant->getType() ) 
        {
            current = hkReflect::Var(variant->getObject(), variant->getType());
        }
    }

    const hkReflect::Type* currentKlass = current.getType();

    while (currentKlass) // We repeat the process each time we go up the hierarchy of classes
    {
        hkStringOld className = currentKlass->getName();

        for( int i=0; i<numIconPairs; ++i )
        {
            if( className.compareTo( iconPairs[i].m_className ) == 0 )
            {
                imageIndex = iconPairs[i].m_iconIndex;
                iconFound = true;
                break;
            }
        }

        currentKlass = currentKlass->getParent();
    }

    // No icon found - pick a generic one
    if (!iconFound)
    {
        const int GENERIC_ICON = 21;
        const int CLOTH_GENERIC_ICON = 33;

        if (hkString::beginsWith(var.getType()->getName(), "hcl"))
        {
            imageIndex = CLOTH_GENERIC_ICON;
        }
        else
        {
            imageIndex = GENERIC_ICON;
        }
    }
}

void hctTreeViewManager::addItem( HTREEITEM parent, const hkVariant& var )
{
    // don't want to have an ever growing array of vars to obj, so we look if it is in there already (from a prev expand / collapse)
    int varIndex = getVariantIndex( var );

    TVINSERTSTRUCTW tvi;
    tvi.hInsertAfter = TVI_ROOT;
    tvi.itemex.mask = TVIF_CHILDREN | TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_PARAM;
    tvi.hParent = parent;
    tvi.itemex.iImage = tvi.itemex.iSelectedImage = 0; // 0 == unknown
    tvi.itemex.lParam = varIndex; // index into the variant array.

    hkStringOld name;
    hkArray< hkVariant > children;
    int imageIndex;
    getItemData( var, name, children, imageIndex );

    hkUtf8::WideFromUtf8 nameWide(name.cString());

    tvi.itemex.pszText = const_cast<LPWSTR>((const wchar_t*)nameWide);
    tvi.itemex.iImage = tvi.itemex.iSelectedImage = imageIndex;
    tvi.itemex.cChildren = children.getSize() > 0? 1 : 0;

    SendMessageW(m_treeWnd, TVM_INSERTITEMW, 0, (LPARAM)(LPTV_INSERTSTRUCTW)(&tvi)); // Wide char version of TreeView_InsertItem( m_treeWnd, &tvi );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
