// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

    /// This class provides utilities used to access the windows registry - it is used to store processing options
    /// associated to the user/machine rather than the asset. For example, this is used by the Preview Scene
    /// filter in order to store options regarding scene navigation and interaction.
class hctOptionsRegistry
{
    public:

            /// Constructor - takes the name of the filter, which will be used in order to construct the key used
            /// to store/read the values in the registry.
        hctOptionsRegistry (const char* filterName);

            /// Returns an integer value associated with "option" stored in the registry. If not found, it returns iDefault.
        int getIntWithDefault (const char* option, int iDefault);

            /// Stores an integer value associated with "option" in the registry.
        void setInt (const char* option, int i);

            /// Returns a boolean value associated with "option" stored in the registry. If not found, it returns bDefault.
        bool getBoolWithDefault (const char* option, bool bDefault);

            /// Stores a boolean value associated with "option" in the registry.
        void setBool (const char* option, bool b);

    private:

        HKEY m_registryKey;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
