// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/Common/hctFilterCommon.h>

hctOptionsRegistry::hctOptionsRegistry (const char* filterName)
{

#ifdef HK_PLATFORM_WIN64
    const char leadingPath[] = "Software\\Havok\\hkFilters_x64\\";
#else
    const char leadingPath[] = "Software\\Havok\\hkFilters\\";
#endif
    hkStringBuf keyPath(leadingPath, filterName);

    DWORD dispos;
    RegCreateKeyEx( HKEY_CURRENT_USER, keyPath.cString(), 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &m_registryKey, &dispos);
}

int hctOptionsRegistry::getIntWithDefault ( const char* option, int iDefault)
{
    DWORD v;
    DWORD vSize = sizeof(DWORD);
    if ( RegQueryValueEx( m_registryKey, TEXT(option), NULL, NULL, (LPBYTE)&v, &vSize ) == ERROR_SUCCESS )
    {
        return (int)v;
    }

    return iDefault;
}

void hctOptionsRegistry::setInt (const char* option, int val)
{
    DWORD v, vSize;
    v = (DWORD)val;
    vSize = sizeof(DWORD);
    RegSetValueEx( m_registryKey, TEXT(option), NULL, REG_DWORD, (LPBYTE)&v, vSize );
}

bool hctOptionsRegistry::getBoolWithDefault (const char* option, bool bDefault)
{
    return getIntWithDefault(option, bDefault? 1 : 0) ? true : false;
}

void hctOptionsRegistry::setBool (const char* option, bool b)
{
    setInt(option, (int)b);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
