// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/Common/hctFilterCommon.h>
#include <ContentTools/Common/Filters/Common/Utils/hctLocaleScope.h>

#include <Common/Base/Container/String/hkUtf8.h>

namespace
{
    static HK_ALWAYS_INLINE void _checkLocale( const wchar_t* locale )
    {
        if( !locale )
        {
            HK_WARN_ALWAYS( 0x1293612A, "Failed to set locale to \"" << locale << "\"!" );
            HK_ASSERT( 0x1293612A, false, "Failed to set locale!" );
        }
    }
}

hctLocaleScope::hctLocaleScope()
{
    // Query current locale, then temporarily switch it to "C"
    const wchar_t* resultantLocale = ::_wsetlocale( LC_NUMERIC, NULL );
    _checkLocale( resultantLocale );

    m_oldLocale = hkUtf8::Utf8FromWide( resultantLocale );

    _checkLocale( ::_wsetlocale( LC_NUMERIC, L"C" ) );
}

hctLocaleScope::~hctLocaleScope()
{
    // Revert to old locale
    _checkLocale( ::_wsetlocale( LC_NUMERIC, hkUtf8::WideFromUtf8( m_oldLocale ) ) );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
