// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/Common/hctFilterCommon.h>
#include <ContentTools/Common/Filters/Common/Utils/hctLocalFrameUtils.h>

#include <Common/Base/Math/Matrix/hkMatrixDecomposition.h>
#include <Common/Base/Types/Geometry/LocalFrame/hkLocalFrame.h>
#include <Common/Base/Container/StringMap/hkStringMap.h>
#include <Common/SceneData/Graph/hkxNode.h>
#include <Common/SceneData/Attributes/hkxAttributeGroup.h>

#define DEBUG_LOG_DEFAULT_LEVEL Info
#define DEBUG_LOG_IDENTIFIER "hct.utils"
#include <Common/Base/System/Log/hkLog.hxx>


hkLocalFrame* hctLocalFrameUtils::createLocalFrames(    const class hkxNode* node,
                                                        const hkxScene* scene,
                                                        bool isRoot,
                                                        hkPointerMap<const hkxNode*,int>* ignoreNodes,
                                                        hkStringMap<hkLocalFrameGroup*>& groupsCreated )
{
    if ( !isRoot )
    {
        // if we find a rigid body that is not ourselves (root) then we terminate the search, since
        // any leafward handles belong to it, not us
        if ( node->findAttributeGroupByName("hkRigidBody") != HK_NULL )
        {
            return HK_NULL;
        }

        // when not at the root, exclude certain nodes
        if ( ( ignoreNodes != HK_NULL ) && ( ignoreNodes->getWithDefault( node, -1 ) != -1 ) )
        {
            return HK_NULL;
        }
    }

    hkSimpleLocalFrame* localFrame = new hkSimpleLocalFrame();

    if ( isRoot )
    {
        localFrame->m_transform.setIdentity();
    }
    else
    {
        const hkMatrix4& m = node->m_keyFrames[0];
        hkMatrixDecomposition::Decomposition decomposition;
        hkMatrixDecomposition::decomposeMatrix(m, decomposition);

        // the translation needs to take the scale into consideration
        if ( decomposition.m_hasScale )
        {
            decomposition.m_translation(0) /= decomposition.m_scale(0);
            decomposition.m_translation(1) /= decomposition.m_scale(1);
            decomposition.m_translation(2) /= decomposition.m_scale(2);
        }

        localFrame->m_transform.setTranslation( decomposition.m_translation );
        localFrame->m_transform.setRotation( decomposition.m_rotation );
    }

    // see if this is tagged as a local frame.
    const hkxAttributeGroup* lfAttribs = node->findAttributeGroupByName("hkLocalFrame");

    // Set the name of the local frame
    if ( lfAttribs != HK_NULL )
    {
        const char* localFrameName = HK_NULL;
        lfAttribs->getStringValue("localFrameName", false, localFrameName);
        localFrame->m_name = localFrameName;

        const char* localFrameGroup = HK_NULL;
        lfAttribs->getStringValue("localFrameGroup", false, localFrameGroup);

        if ( ( localFrameGroup != HK_NULL ) && ( hkString::strLen( localFrameGroup ) > 0 ) )
        {
            hkLocalFrameGroup* group = HK_NULL;
            group = groupsCreated.getWithDefault( localFrameGroup, HK_NULL );

            if ( group == HK_NULL )
            {
                group = new hkLocalFrameGroup( localFrameGroup );
                groupsCreated.insert( group->getName(), group );

                localFrame->setGroup( group );
                group->removeReference();

                Log_Info( "Created group named \"{}\".", localFrameGroup );
            }
            else
            {
                localFrame->setGroup( group );
            }

        }
    }

    for( int c = 0; c < node->m_children.getSize(); c++ )
    {
        hkxNode* child = node->m_children[c];
        hkLocalFrame* childFrame = createLocalFrames( child, scene, false, ignoreNodes, groupsCreated );

        if ( childFrame != HK_NULL )
        {
            localFrame->m_children.pushBack( childFrame );
            childFrame->setParentFrame( localFrame );
        }
    }

    if ( ( lfAttribs == HK_NULL ) && ( localFrame->m_children.getSize() == 0 ) )
    {
        localFrame->removeReference();
        return HK_NULL;
    }
    else if ( isRoot && ( localFrame->m_children.getSize() == 1 ) )
    {
        hkLocalFrame* childFrame = localFrame->m_children[0];
        childFrame->setParentFrame( HK_NULL );
        childFrame->addReference();
        localFrame->removeReference();
        return childFrame;
    }
    else
    {
        hkStringOld str;

        if ( localFrame->getName() == HK_NULL )
        {
            str.printf( "Created local frame with no name." );
        }
        else
        {
            str.printf( "Created local frame named \"%s\".", localFrame->getName() );
        }

        Log_Info( str.cString() );

        return localFrame;
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
