// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/Filters/Common/Filter/hctFilterDescriptor.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Base/Container/String/Deprecated/hkStringOld.h>
#include <ContentTools/Common/Filters/Common/Options/hctPlatformWriterOptions.h>
#include <ContentTools/Common/Filters/Common/Options/hctFilterRemoteUpdateOptions.h>

#define HCT_PREVIEW_TOOL_FILENAME "PreviewTool.exe"

class hkResource;

    /// A collection of useful utility methods for the filters and exporters
class hctFilterUtils
{
    public:

            /// Create a complete copy of an entire filter set,
            /// so that processing does not affect the original data.
        static void* deepCopyObject ( const void* obj, const hkReflect::Type* klass, hkResource*& sceneCopyData );

        template<typename T>
        static T* deepCopyObject( const T* obj, hkResource*& sceneCopyData )
        {
            return (T*)deepCopyObject(obj, hkReflect::getType<T>(), sceneCopyData);
        }

            /// Create an array using the items listed in the delimited string.
        static void createArrayFromDelimitedString( hkArray<hkStringOld>& buf, const char* delimitedString, const char delimiter );

        /// Create an array using the items listed in the delimited string.
        static void createArrayFromDelimitedString( hkArray<hkStringPtr>& buf, const char* delimitedString, const char delimiter );

            /// Create an array using the items listed in the delimited string - using a full hkStringOld delimiter
        static void createArrayFromDelimitedString( hkArray<hkStringOld>& buf, const char* delimitedString, const hkStringOld& delimiter );

            /// Create a single string from the given array of strings, using "delimiter" to split the strings.
        static void createDelimitedStringFromArray( const hkArray<hkStringOld>& array, const char* delimiter, hkStringOld& delimitedStringOut);

            /// Create a single string from the given array of strings, using "delimiter" to split the strings.
        static void createDelimitedStringFromArray( const hkArray<hkStringPtr>& array, const char* delimiter, hkStringOld& delimitedStringOut);

            /// Create an array of array of strings from a delimited string using an inner and outer delimiter
        static void createArrayOfArrayOfStringsFromDelimitedString( hkArray< hkArray< hkStringOld > >& out, const char* delimitedString, char inner, char outer );

        /// Create an array of array of strings from a delimited string using an inner and outer delimiter
        static void createArrayOfArrayOfStringsFromDelimitedString( hkArray< hkArray< hkStringPtr > >& out, const char* delimitedString, char inner, char outer );

            /// Create a single string from a given array of array of strings using an inner and outer delimiter
        static void createDelimitedStringFromArrayOfArrayOfStrings( const hkArray< hkArray< hkStringOld > >& in, hkStringOld& out, char inner, char outer );

            /// Create a single string from a given array of array of strings using an inner and outer delimiter
        static void createDelimitedStringFromArrayOfArrayOfStrings( const hkArray< hkArray< hkStringPtr > >& in, hkStringOld& out, char inner, char outer );

            /// Returns the path to the specified asset file. It does so by looking for an hkxEnvironment in the asset and otherwise
            /// by looking at the asset name in the hkxScene object.
        static void getAssetFolder( const hkRootLevelContainer& rootLevelContainer, hkStringOld& assetFolderOut );

            /// Given a filename, it detects whether it is relative or not to the asset path, and in that case
            /// it prepends it.
        static void getFullPath ( const hkRootLevelContainer& rootLevelContainer, const char* userPath, hkStringOld& fullPathOut);

            /// Get the path to the specified file relative to the specified asset path.
        static void getReducedFilename( const wchar_t* fname, const hkStringOld& assetPath, hkStringOld& reducedName );

            /// Looks for an hkxEnvironment inside the given contents, and queries for the given variable. If not present,
            /// it will try to use data in hkxScene. Returns HK_NULL if no environment was found or the variable is undefined.
        static const char* getEnvironmentVariable (const hkRootLevelContainer& contents, const char* variable);

        /// Looks for a Windows environment variable with the given name
        static const char* getOSEnvironmentVariable (const char* variable);

            /// Given an hkxEnvironment and an input string, it returns (through outputString) the string with all substrings
            /// of the form \$(name) replaced by its corresponding value in the environment. Returns true if all substitutions
            /// succeeded, false otherwise.
        static bool replaceVariables (const class hkxEnvironment& environment, const char* inputString, hkStringOld& outputString, hkBool useOSEnvironment = false);

            /// Converts a category code to its string representation
        static const char* filterCategoryToString( hctFilterDescriptor::FilterCategory c );


            /// Move non-eportable classes to the end of the root-level container, and return their count
        static int moveNonExportablesToEnd( class hkRootLevelContainer& data );

            /// True if this class is expected to be exported, false if it is not (typically internal data for the filter stack only)
        static bool isExportable( const hkRootLevelContainer::NamedVariant& a );

            /// Utility function to sort named variants based on their exportability
        static bool compareExportableLess( const hkRootLevelContainer::NamedVariant& a, const hkRootLevelContainer::NamedVariant& b );

            /// Attempts to resolve the absolute path to the given script, based on the path of the current asset
        static hkResult HK_CALL resolvePath(const char* fileName, const char* assetPath, hkStringBuf& filePathOut);

        /// Returns a copy of the options in the native up-to-date format.
        /// Returns null and prints a warning if the type of the loaded options does not correspond to the native one.
        // todo.compat this should do versioning and copyToNative
        static hkReflect::Var getNativeOptions(const hkReflect::Var& loadedOptions, const hkReflect::Type* nativeType);

            /// Utility function to write out the contents of the stream. The format details are provided in the options.
        static hkResult writeToPlatform(hkRootLevelContainer& data, hkStringOld& fileName, const hctPlatformWriterOptions& options);

            /// Utility function to remote update a tool
        static hkResult remoteUpdateTool(
            hkRootLevelContainer& data, const hctFilterToolStubRemoteOptions& options, const hkStringBuf& autoLaunchToolName);

        template<typename T>
        static T* getNativeOptions(const hkReflect::Var& loadedOptions)
        {
            return static_cast<T*>(getNativeOptions(loadedOptions, hkReflect::getType<T>()).getAddress());
        }

        struct EnumItem { int m_value; const char* m_name; };

            /// Collection of name-value pairs.
        typedef hkArrayView<EnumItem> Enum;

            /// Gets the value corresponding to the given name.
        static int getValueOfName(const Enum& en, const char* name, int defValue);

        static void emptyIfNull(hkStringPtr& s) { if (s == HK_NULL) s = ""; }

            // Packfile/Tagfile extensions list for open/save file dialogs
        static const wchar_t s_DialogFileExtensions[];
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
