// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/SceneExport/Error/hctSceneExportError.h>

// This functions is used by filter Dialogs to display ToolTips
BOOL CreateToolTip(int toolID, HWND hDlg, HINSTANCE hInst, hkStringOld toolText);

// This function will print (incl. formatting) the LogEntry to the provided RichEdit control.
void hctPrintLogEntryToRichEditControl(const hctSceneExportError::LogEntry& entry, HWND richEditControl);

// This function will return the value in the specified dialog item as a float
float hctGetDlgItemFloat(__in HWND hDlg, __in int nIDDlgItem);

// This function will return the value in the specified dialog item as a int
int hctGetDlgItemInt(__in HWND hDlg, __in int nIDDlgItem);

// This function will return true if any characters were copied successfully, storing the result in a hkStringPtr
bool hctGetDlgItemHkStringPtr(__in HWND hDlg, __in int nIDDlgItem, hkStringPtr& text);

// This function will return true if any characters were copied successfully, storing the result in a hkStringPtr
bool hctGetWindowHkStringPtr(__in HWND hWnd, hkStringPtr& text);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
