// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/Common/hctFilterCommon.h>
#include <ContentTools/Common/Filters/Common/Utils/hctFilterDialogUtils.h>

#include <Common/Base/Container/String/hkUtf8.h>

#include <richedit.h>

// This functions is used by filter Dialogs to display ToolTips
BOOL CreateToolTip(int toolID, HWND hDlg, HINSTANCE hInst, hkStringOld toolText)
{
    // toolID:      the resource ID of the control.
    // hDlg:        the handle of the dialog box.
    // hInstance:   the global instance handle.
    // toolText:    the text that appears in the ToolTip.

    const char* pText = toolText.cString();

    // Calculate amount of time that the ToolTip remains visible and clamp it between 5000ms and 32000ms
    int visibleTime = hkMath::clamp(toolText.getLength() * 100, 5000, 32000);

    if (!toolID || !hDlg || !pText)
    {
        return FALSE;
    }
    // Get the window of the tool.
    HWND hwndTool = GetDlgItem(hDlg, toolID);

    // Create the ToolTip.
    HWND hwndTip = CreateWindowEx(NULL, TOOLTIPS_CLASS, NULL, WS_POPUP | TTS_ALWAYSTIP | TTS_NOPREFIX, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, hDlg, NULL, hInst, NULL);

    if (!hwndTool || !hwndTip)
    {
        return FALSE;
    }

    // Associate the ToolTip with the tool.
    TOOLINFO toolInfo = { 0 };
    toolInfo.cbSize = sizeof(toolInfo);
    toolInfo.hwnd = hDlg;
    toolInfo.uFlags = TTF_IDISHWND | TTF_SUBCLASS;
    toolInfo.uId = (UINT_PTR)hwndTool;
    toolInfo.lpszText = const_cast<LPSTR>(pText);
    SendMessage(hwndTip, TTM_ADDTOOL, 0, (LPARAM)&toolInfo);
    // Set width of ToolTip window
    SendMessage(hwndTip, TTM_SETMAXTIPWIDTH, 0, 300);
    // Set the amount of time the ToolTip remains visible (in milliseconds). Default = 5000ms
    SendMessage(hwndTip, TTM_SETDELAYTIME, TTDT_AUTOPOP, visibleTime);

    return TRUE;
}

void hctPrintLogEntryToRichEditControl(const hctSceneExportError::LogEntry& entry, HWND richEditControl)
{
    if( !richEditControl )
    {
        return;
    }

    // Create character format
    CHARFORMATW format;
    {
        format.cbSize = sizeof(CHARFORMATW);
        format.dwMask = CFM_COLOR | CFM_BOLD;

        if (entry.m_customColor)
        {
            format.crTextColor = entry.m_color;
            format.dwEffects = CFE_BOLD;
        }
        else
        {
            switch( entry.m_type )
            {
            case hctSceneExportError::MESSAGE_REPORT:
                format.crTextColor = RGB(0,0,0);
                format.dwEffects = 0;
                break;

            case hctSceneExportError::MESSAGE_WARNING:
                format.crTextColor = RGB(255,127,0);
                format.dwEffects = CFE_BOLD;
                break;

            case hctSceneExportError::MESSAGE_ASSERT:
            case hctSceneExportError::MESSAGE_ERROR:
                format.crTextColor = RGB(255,0,0);
                format.dwEffects = CFE_BOLD;
                break;

            default:
                break;
            }
        }
    }

    char buf[1024];
    hkStringOld entryText;

    // If the string is empty, the only effect is the newline (EXP-1289)
    if ( entry.m_text.getLength() > 0 )
    {
        int spacesStart = 0;
        while (entry.m_text[spacesStart]==' ') spacesStart++;

        int spacesEnd;
        if ( spacesStart == entry.m_text.getLength() )
        {
            // string consists entirely of spaces (EXP-1289)
            spacesEnd = 0;
        }
        else
        {
            spacesEnd = 0;
            while (entry.m_text[entry.m_text.getLength()-1-spacesEnd]==' ') spacesEnd++;
        }

        entryText = entry.m_text.substr(spacesStart, entry.m_text.getLength()-spacesStart-spacesEnd);

        // Interpret enclosing * (italics) , [] (bold) and __ (underline) as formatting hints
        bool someEffect = false;
        do
        {
            someEffect = false;

            if (entryText.beginsWith("*") && entryText.endsWith("*") &&entryText.getLength()>2)
            {
                entryText = entryText.substr(1,entryText.getLength()-2);
                format.dwEffects |= CFE_ITALIC;
                format.dwMask |= CFM_ITALIC;
                someEffect = true;
            }

            if (entryText.beginsWith("[") && entryText.endsWith("]") &&entryText.getLength()>2)
            {
                entryText = entryText.substr(1,entryText.getLength()-2);
                format.dwEffects |= CFE_BOLD;
                someEffect = true;
            }

            if (entryText.beginsWith("_") && entryText.endsWith("_") &&entryText.getLength()>2)
            {
                entryText = entryText.substr(1,entryText.getLength()-2);
                format.dwEffects |= CFE_UNDERLINE;
                format.dwMask |= CFM_UNDERLINE;
                someEffect = true;
            }

        } while (someEffect);

        // Put spaces back
        entryText = entry.m_text.substr(0,spacesStart) + entryText + entry.m_text.substr(entry.m_text.getLength()-1-spacesEnd, spacesEnd);
    }

    // Create text buffer
    {
        hkOstream os(buf, sizeof(buf), true);
        os << entryText.cString() << "\n";
    }

    SETTEXTEX setTextEx;
    setTextEx.flags = ST_SELECTION;
    setTextEx.codepage = CP_UTF8;

    // Add the new line at the end of the edit box
    SendMessageW( richEditControl, EM_SETSEL, (WPARAM)-1, -1);
    SendMessageW( richEditControl, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&format );
    SendMessageW( richEditControl, EM_SETTEXTEX, (WPARAM)&setTextEx, (LPARAM)buf);
    SendMessageW( richEditControl, WM_VSCROLL, SB_BOTTOM, NULL );   // EM_SCROLLCARET only works if focused
}

float hctGetDlgItemFloat(__in HWND hDlg, __in int nIDDlgItem)
{
    static wchar_t buffer[32];
    buffer[0] = '\0';

    GetDlgItemTextW(hDlg, nIDDlgItem, buffer, HK_COUNT_OF(buffer));

    return static_cast<float>(_wtof(buffer));
}

int hctGetDlgItemInt(__in HWND hDlg, __in int nIDDlgItem)
{
    BOOL result = TRUE;
    int value = GetDlgItemInt(hDlg, nIDDlgItem, &result, TRUE);

    if (result == FALSE)
    {
        value = 0;
    }

    return value;
}

bool hctGetDlgItemHkStringPtr(__in HWND hDlg, __in int nIDDlgItem, hkStringPtr& text)
{
    return hctGetWindowHkStringPtr(GetDlgItem(hDlg, nIDDlgItem), text);
}

bool hctGetWindowHkStringPtr(__in HWND hWnd, hkStringPtr& text)
{
    hkInplaceArray<wchar_t, 1024> inplace;

    int chars = GetWindowTextLengthW(hWnd) + 1;

    inplace.setSize(chars);
    inplace[0] = '\0';

    if (GetWindowTextW(hWnd, &inplace[0], chars) >= 0)
    {
        text = hkUtf8::Utf8FromWide(inplace.begin());
        return true;
    }
    else
    {
        return false;
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
