// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/Reflect/Version/hkReflectPatchRegistry.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>

void hctPlatformWriterOptions_0_to_1(hkDataObject& obj)
{
    enum Preset_0
    {
        CUSTOM,
        MSVC_WIN32,
        MSVC_XBOX,
        MSVC_AMD64,
        GCC_AMD64,
        CW_PS2,
        CW_GAMECUBE,
        CW_PSP,
        CW_WII,
        GCC33_PS2,
        GCC32_PS2,
        GCC295_PS2,
        SN31_PS2,
        SN393_GAMECUBE,
        SNC_PSP,
        GCC151_PSP,
        X360,
        GCC_PS3,
        MAC_PPC,
        MAC_386,
        XML,
        SNC_VITA,
        GCC_ANDROID,
        RVCT_3DS,
        GHS_WIIU,
        PS4,
        XBOXONE,
    };

    enum Format_1
    {
        FORMAT_PORTABLE,
        FORMAT_NATIVE,
        FORMAT_XML
    };

    // bools to enum
    if (obj["tagfile"].asInt())
    {
        if (obj["xmlFormat"].asInt())
        {
            obj["format"] = FORMAT_XML;
        }
        else
        {
            obj["format"] = FORMAT_PORTABLE;
        }
    }
    else
    {
        obj["format"] = FORMAT_NATIVE;
    }


    switch(obj["preset"].asInt())
    {
    case MSVC_WIN32:
        obj["target"] = "32m"; break;
    case MSVC_AMD64:
    case XBOXONE:
        obj["target"] = "64m"; break;
    case GCC_AMD64:
    case PS4:
        obj["target"] = "64g"; break;
    case MAC_386:
        obj["target"] = "32g"; break;
    case SNC_VITA:
    case GCC_ANDROID:
        obj["target"] = "32a"; break;
    default:
        HK_WARN(0xabbaa4dd, "Write to Platform native format is not supported anymore, setting to MSVC 32");
        obj["target"] = "32m";
    }
}

void registerCommonPatches(hkReflect::Version::PatchHandler& man)
{
#   define HK_PATCHES_FILE "ContentTools/Common/Filters/Common/Patches/hctCommonPatches.hxx"
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
