// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Reflect/Builder/hkTypeCopier.h>

/// Describes the platform writer options.
class hctPlatformWriterOptions
{
    public:

        HK_DECLARE_CLASS(hctPlatformWriterOptions, New, Reflect);
        HK_RECORD_ATTR(hk::Version(1));

        /// Default constructor
        hctPlatformWriterOptions() :
            m_filename(HK_NULL),
            m_format(FORMAT_PORTABLE),
            m_target("32m"),
            m_saveEnvironmentData(false)
        {

        }

    public:

        // finds a specific target
        static int findTargetIndex(const char* target)
        {
            hkArrayView<const hkReflect::TypeCopier::Target> targets = hkReflect::TypeCopier::getTargetStrings();
            for (int i = 0; i < targets.getSize(); ++i)
            {
                if (hkString::strCmp(target, targets[i].m_name) == 0)
                {
                    return i;
                }
            }
            return -1;
        }

        static const char* getTargetName(hkUlong idx)
        {
            return hkReflect::TypeCopier::getTargetStrings()[hkLosslessCast<int>(idx)].m_name;
        }

    public:

        enum Format
        {
            FORMAT_PORTABLE,
            FORMAT_NATIVE,
            FORMAT_XML
        };

        /// The filename to export as. It is the name less the 'common path' between what
        /// was entered / selected and what the current asset is called.
        hkStringPtr m_filename;

        /// Use portable binary format
        hkEnum<Format, hkInt8> m_format;

        /// Chosen native target
        hkStringPtr m_target HK_ATTR(hk::Default("32m"));

        /// Whether environment data is saved
        hkBool m_saveEnvironmentData; //+default(false)

};

HK_REFLECT_ENUM(,hctPlatformWriterOptions::Format);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
