// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/String/Deprecated/hkStringOld.h>
#include <Common/Base/Reflect/Util/hkReflectAny.h>

/// This class stores a set of filter configurations,
/// and handles loading/saving of that data
class hctFilterConfigurationSet
{
    public:

        /// Structure describing a single filter stage
        struct FilterStage
        {
            HK_DECLARE_CLASS(FilterStage, New, Reflect, BypassCtor);

            FilterStage() : m_index(-1), m_filterId(0) {}

            int             m_index HK_ATTR( hk::Serialize(false) ); // enumerated filter index (not saved)
            unsigned int    m_filterId;
            unsigned int    m_optionDataVersion;    // version of the filter that saved the options
            hkReflect::Any  m_options;
        };

        /// Structure describing a single configuration of multiple filters
        struct Configuration
        {
            HK_DECLARE_CLASS(Configuration, New, Reflect, BypassCtor);

            Configuration() {}
            Configuration( const Configuration& other );

            hkStringPtr             m_configName;
            hkArray<FilterStage>    m_filterStages;
        };

        /// Represents behaviour of any hkOverride.HKO or hkUpgrade.HKO file present
        enum OverrideMode
        {
            MODE_NORMAL,
            MODE_OVERRIDE,
            MODE_UPGRADE
        };

        HK_DECLARE_CLASS(hctFilterConfigurationSet, New, Reflect, BypassCtor);

        /// Construction/destruction
        hctFilterConfigurationSet( const class hctFilterManagerInterface* filterManager );
        ~hctFilterConfigurationSet();

        /// Get/set the data
        int getData( void* optionData ) const;
        void setData( const void* optionData, int optionDataSize );

        /// Check if the data has changed in any way since it was originally set
        bool hasDataChanged();

        /// Get the current override mode
        const OverrideMode getOverrideMode() const { return m_overrideMode; }

        /// Get the current configuration
        Configuration& getCurrentConfiguration() { return m_configurations[ m_currentIndex ]; }

        const class hctFilterManagerInterface* getFilterManager() const { return m_filterManager; }

        /// The set of configurations
        hkArray<Configuration> m_configurations;
        int m_currentIndex;


    private:

        /// Handle a single configuration ( used in get/setConfigurationSet() )
        int getConfigurationData( void* optionData, int configurationIndex ) const;

        /// Owner
        const class hctFilterManagerInterface* m_filterManager HK_ATTR( hk::Reflect(false) );

        /// Overrides
        hkArray<char> m_originalData HK_ATTR( hk::Reflect(false) );
        OverrideMode m_overrideMode HK_ATTR( hk::Reflect(false) );
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
