// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/Filters/Common/hctBaseDll.h>

class hctFilterManagerDll;
class hctFilterManagerInterface;

    /// Prototype for the DLL-exported method
typedef hctFilterManagerDll* (__cdecl *hkGetFilterManagerDllFunc) (HMODULE dllModule);

    /// The DLL implementing the filter manager should contain an instance of this class and expose it through the DLL via
    /// a getFilterManagerDLL() exported function (see hkGetFilterManagerDllFunc for the prototype).
    /// This class inherits from hctBaseDll, extending it with methods to create and destroy a filter manager.
class hctFilterManagerDll : public hctBaseDll
{
    public:

            /// Constructor. Requires a Handle to the DLL (returned by LoadLibrary() and passed to getFilterManagerDll());
        hctFilterManagerDll (HMODULE dllModule) : hctBaseDll (dllModule) {}

            /// Constructs and return an instance of hctFilterManagerInterface.
        virtual hctFilterManagerInterface* createFilterManager(const hkMemoryInitUtil::SyncInfo* memSyncInfo, hkBool interactive) = 0;

            /// Destroys the given filter manager.
        virtual void deleteFilterManager (hctFilterManagerInterface* f) = 0;

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
