// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

namespace hkReflect
{
    class Any;
}

/// The interface for all filters. Each filter needs to implement the methods below,
/// the most important of which is process() - the one that does the job.
/// Internally the actual filter is usually memory managed by Havok for instance,
/// but any filter can use memory management as it sees fit.
class hctFilterInterface : public hkReferencedObject
{
    public:

            /// Constructor. It takes a pointer to the filter manager that owns it.
        hctFilterInterface (const class hctFilterManagerInterface* owner);

            /// Virtual destructor
        virtual ~hctFilterInterface ();

            /// Bring up a child dialog to allow the user to set options for this filter.
            /// It should return a handle to the dialog (that may get repositioned).
            /// hideOptions() will be called on it sometime in the future and it can delete the window.
            /// By default returns HK_NULL (no options to display).
        virtual HWND showOptions ( HWND owner );

            /// Hide the dialog brought up during showOptions.
        virtual void hideOptions ();

            /// Set the options for this filter.
        virtual void setOptions(const hkReflect::Var& optVar);
            /// Get the options for this filter.
        virtual void getOptions(hkReflect::Any& buffer) const;

            /// Process the given contents. The main method in any filter. There are different process modes, see filterInterafce->getProcessMode to
            /// work out if you should show UI or not during processing.
        virtual void process ( class hkRootLevelContainer& contents ) = 0;

            /// Gets the file dependencies i.e., files that are read or written to by the filter.
        virtual void getFileDependencies(const class hkRootLevelContainer& data, hkArray<hkStringPtr>& filesOut);

            /// Returns a pointer to the filter manager that created this filter.
        const hctFilterManagerInterface* getFilterManager () const;

    protected:

        const class hctFilterManagerInterface* m_filterManager;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
