// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/Common/hctFilterCommon.h>

#include <Common/Base/System/Error/hkDefaultError.h>
#include <Common/Base/DebugUtil/MultiThreadCheck/hkMultiThreadCheck.h>
#include <Common/Base/Monitor/hkMonitorStream.h>
#include <Common/Base/Memory/Allocator/Malloc/hkMallocAllocator.h>
#include <Common/Base/Config/hkProductFeatures.h>

hctModelessFilterDll::hctModelessFilterDll (HMODULE dllModule) : hctFilterDll (dllModule)
{

}

/*static*/ void hctModelessFilterDll::errorReportFunction(const char* buf, void *obj)
{
    // just output to the debug stream and try to carry on..
    OutputDebugString( buf );
}

/*virtual*/ void hctModelessFilterDll::initDll( const hkMemoryInitUtil::SyncInfo& baseSystemInfo, hkError* errorStream)
{
    extern hkBool hkBaseSystemIsInitialized;
    if (baseSystemInfo.m_memoryRouter) // allow dummy init, so that all DLLs can be cached (incl Cloth dll children etc)
    {
        hkMemoryInitUtil::SyncInfo::syncLocalInitNodes(baseSystemInfo,
            hkMemoryInitUtil::SyncInfo::EXCLUDE_VERSION_REGISTRY);

        hkMonitorStream::init();

        //  We don't use the manager's error handler as this is a modeless filter
        hkError::replaceInstance ( new hkDefaultError (errorReportFunction, HK_NULL)  );

        hkMultiThreadCheck::staticInit(hkMallocAllocator::m_defaultMallocAllocator);

        hkBaseSystem::initNodes(&hkBaseSystem::InitNode::s_listHead);

        hkProductFeatures::initialize();

        hkBaseSystemIsInitialized = true;
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
