// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/Filters/Common/Filter/hctFilterDescriptor.h>

class hctModelessFilter;

// The descriptor of a modeless filter tracks the active instances of the filter
class hctModelessFilterDescriptor : public hctFilterDescriptor
{
    public:

            /// Constructor
        hctModelessFilterDescriptor();

            /// Destructor
        virtual ~hctModelessFilterDescriptor();

        /*virtual*/ const char* getShortName() const { return "Modeless Filter"; }

            /// From hctFilterDescriptor, returns how many modeless filters are active
        /*virtual*/ int countModelessFilters (int& numActiveOut, int& numClosingout) const;

            /// From hctFilterDescriptor, tells all modeless filters to close asap
        /*virtual*/ void askModelessFiltersToClose () const;

            /// Adds a filter to the "active filters list", i.e., keeps track of it
            ///
        void addFilterToActiveList (hctModelessFilter* filter);

            /// Removes a filter from the "active filters list"
        void removeFilterFromActiveList (hctModelessFilter* filter);

            /// Returns the i-th filter in the active filters list
        hctModelessFilter* getActiveFilter (int i) const;

    private:

            // Linked list of active instances of this filter
        struct ActiveFilterList
        {
            hctModelessFilter* m_activeFilter;
            ActiveFilterList* m_next;
        };

        ActiveFilterList* m_activeFilterList;
        mutable HANDLE m_activeFiltersMutex;

        // Creates the mutex if not already created
        void createMutexIfNecessary () const;

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
