// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/Filters/Common/Filter/hctFilterInterface.h>

class hkResource;

/// This class provides a default implementation for a modeless filter - it handles the creation of threads for processing.
/// Filters inheriting from this class must implement modalProcess() instead of process() - inside modalProcess() they can/should
/// operate modally (since a new thread is created for that call).
/// The other abstract methods are required in order to properly handle "shutdown" requests from the filter manager.
class hctModelessFilter : public hctFilterInterface
{
    public:

            /// Constructor. It takes a pointer to the filter manager that owns it.
        hctModelessFilter (const class hctFilterManagerInterface* owner);

            /// Destructor - waits for thread, etc
        /*virtual*/ ~hctModelessFilter ();

            /// Filters subclassing from hctModelessFilter should implement their processing here instead of in process().
            /// This will be called from a new thread, so processing here can be modal.
        virtual void modalProcess ( class hkRootLevelContainer& contents ) = 0;

            /// Access to the descriptor.
        virtual class hctModelessFilterDescriptor& getDescriptor() const = 0;

            /// Notifies the (modeless) filter that it should close asap. Usually the filter will set a flag that is checked
            /// by the modal processing method.
        virtual void tryToClose () = 0;

            /// Should return true if the filter is closing down (not blocked). Useful for filters that may take some time to close down,
            /// so the user/filter manager can distinguish between blocked filters and slow filters. By default it returns false - slow
            /// filters should implement this so it returns true when closing down.
        virtual bool isClosingDown () const;

            /// Modeless filters can be treated as modal if desired. Override this method in order to do so.
            /// Default implementation returns false;
        virtual bool behaveAsModal () const ;

            /// Inherited from hctFilterInterface, this implementation copies the contents and creates a new thread to process it,
            /// through the use of "modalProcess()".
        /*virtual*/ void process ( class hkRootLevelContainer& contents ); /* sealed */

            /// Returns true if the thread created for the modeless filter is still active
        bool isThreadActive () const ;


            /// Storage data used to clone the scene
        hkResource* m_cloneStorage;

    protected:

        /// The thread used by this
        HANDLE m_filterThread;

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
