// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <ContentTools/Common/Filters/Common/hctFilterCommon.h>

#include <Common/Base/System/hkBaseSystem.h>
#include <Common/Base/Monitor/hkMonitorStream.h>
#include <Common/Base/Serialize/Resource/hkResource.h>

hctModelessFilter::hctModelessFilter (const class hctFilterManagerInterface* owner) : hctFilterInterface (owner), m_filterThread(0)
{

}

hctModelessFilter::~hctModelessFilter ()
{
    if (m_filterThread) // if == 0, then in throws of shut down or is gone already
    {
        CloseHandle( m_filterThread );
        m_filterThread = HK_NULL;
    }
}

struct _ThreadProcessingData
{
    hctModelessFilter* m_filter;
    hkRootLevelContainer* m_contents;
    hkResource* m_contentData;

};

DWORD WINAPI _modelessFilterThreadFunc( LPVOID lpParam )
{
    _ThreadProcessingData* data = (_ThreadProcessingData*) (lpParam);
    hctModelessFilter* filter = data->m_filter;

    // setup our local thread memory
    // Initialize the thread memory for this thread, referencing the global memory instance
    hkMemoryRouter memoryRouter;
    hkMemorySystem::getInstance().threadInit( memoryRouter, "_modelessFilterThreadFunc");

    // Due to the fact that all the DLLs that created the data for this preview
    // have their own TLS slot for the per thread memory etc, we have to propagate that
    // back though them all..
    {
        // call hkBaseSystem::initThread( &threadMemory ); on all DLLs known to manager (including this one, so we don't need to call it explicitly)
        filter->getFilterManager()->setThreadData(&memoryRouter);
    }

    // Do the processing
    filter->modalProcess(*data->m_contents);

    const hctFilterManagerInterface* manager = filter->getFilterManager();
    filter->getDescriptor().removeFilterFromActiveList(filter); // will delete 'filter'

    if (data->m_contentData)
    {
        data->m_contentData->removeReference();
    }

    // Play nice (handy for debugging as will be null)
    manager->setThreadData(HK_NULL);

    hkBaseSystem::quitThread();
    hkMemorySystem::getInstance().threadQuit(memoryRouter);

    delete data;
    return 0;
}


/*virtual*/ void hctModelessFilter::process( hkRootLevelContainer& contents )
{
    hctFilterManagerInterface::ProcessMode mode = getFilterManager()->getProcessMode();
    if ((mode == hctFilterManagerInterface::PROCESS_BATCH) || (mode == hctFilterManagerInterface::OPTIONS_BATCH))
    {
        return;
    }

    // Current state (to simulate etc with):
    hkResource* clonedData = HK_NULL;
    hkRootLevelContainer* clonedContents = hctFilterUtils::deepCopyObject( &contents, clonedData);

    if (behaveAsModal())
    {
        modalProcess(*clonedContents);
        if (clonedData)
        {
            clonedData->removeReference();
        }
        return;
    }


    // else

    // We add it before creating the thread since we need to make sure the filter is not deleted while the thread starts
    // Thread will remove itself when finished
    getDescriptor().addFilterToActiveList(this);

    // Create preview thread:
    DWORD dwThreadId;

    _ThreadProcessingData* threadData = new _ThreadProcessingData;
    threadData->m_filter = this;
    threadData->m_contents = clonedContents;
    threadData->m_contentData = clonedData;

    m_filterThread = CreateThread(
        NULL, // default security attributes
        0, // default stack size
        _modelessFilterThreadFunc,
        (LPVOID)threadData, // arg
        0, // default creation flags
        &dwThreadId); // returns the thread identifier

    if (m_filterThread == NULL) // wasn't created..
    {
        HK_WARN_ALWAYS(0xabbadea3, "Couldn't create thread for modeless filter");
    }
}

/*virtual*/ bool hctModelessFilter::behaveAsModal () const
{
    return false;
}

/*virtual*/ bool hctModelessFilter::isClosingDown () const
{
    return false;
}

bool hctModelessFilter::isThreadActive () const
{
    DWORD ec;
    return (m_filterThread && GetExitCodeThread(m_filterThread, &ec) && (ec == STILL_ACTIVE));
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
