// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <ContentTools/Common/SceneExport/Error/hctSceneExportError.h>

extern "C"
{
#include <setjmp.h>
}

/// This implementation of hkError is used by the filter manager.
/// Any asserts, warnings or messages are presented to the user in a log window.
/// And serious messages are also stored in a log file.
/// In the case of errors/asserts being raised by any filter, the filter manager will stop processing and (attempt to) recover without causing a crash.
class hctFilterError : public hctSceneExportError
{
public:

    hctFilterError(HWND dialog, const char* logFilePath, hkBool interactive);
    ~hctFilterError();

    /*virtual*/ int message(Message type, int id, const char* description, const char* file, int line);

public:

    jmp_buf* getJumpBuffer();

    void setWindow(HWND dialog);
    void refreshWindow();

    void printToFile(hkStringOld text);
    void clearLog();
    /*virtual*/ void setLogFile(const char* logFile);
    /*virtual*/ void setLogVerboseLevel(unsigned int logVerboseLevel);
    /*virtual*/ void setStdOutput(bool output);

    static int getWarnCount() { return s_warnCount; }
    static int getErrorCount() { return s_errorCount; }

    static void resetCounters() { s_warnCount = s_errorCount = 0; }

protected:

    // These will disable/enable jump buffer usage if you want modify
    // exception handling behavior. Use these with great caution!
    void disableJumpBuffer();
    void enableJumpBuffer();

    void addEntryToWindow(const LogEntry& entry);

    /// By default only warning IDs starting with 0xabba are enabled.
    /// You can disable this warning filter by setting this variable to false by issuing a warning with ID = 0xf0f0f0f0
    /// and reenable the filter with ID = 0xf0f0f0f1.
    hkBool  m_enableWarningFilter;

    class hkOstream*        m_logFile;
    HWND                    m_dialog;

private:

    hkBool m_interactive;
    hkStringPtr m_logFileName;
    hkStringPtr m_logFilePath;
    unsigned int m_logVerboseLevel;
    bool m_stdOutput;
    hkUint64 m_ownerThreadId;
    hkArray<int> m_skippedLogEntries;
    bool m_useJumpBuffer;

    mutable hkCriticalSection m_criticalAccess;

    static int s_warnCount;
    static int s_errorCount;

    friend class hctFilterErrorDisableExceptionHandler;
};

// Helper class to disable the exception handler (long jump) in the hctFilterError
// class within a block. This is to ensure that it isn't disabled and then not
// re-enabled on accident.
class hctFilterErrorDisableExceptionHandler
{
public:
    hctFilterErrorDisableExceptionHandler();
    ~hctFilterErrorDisableExceptionHandler();
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
