// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/hkBase.h>

class hkRootLevelContainer;
class hkxNode;
class hkMeshBody;

/// Main interface exposed by the Dll
class hctDestructionUtils
{
    public:

        enum DllError
        {
            DLL_INTERNAL_ERROR = 0,  // unable to query the DLL at all
            DLL_NO_ERROR = 1,        // DLL did load ok
            DLL_INIT_ERROR = 2,      // DLL is not initialized or failed to init internal structures
            DLL_KEYCODE_EXPIRED = 4, // the DLL keycode has expired, the DLL functions will not work
            DLL_KEYCODE_ILLEGAL = 8, // the DLL keycode is malformed
            DLL_KEYCODE_WARNING = 16 // the DLL keycode is ok but will expire in 10 days
        };

        enum RunOptions
        {
            DEFAULT_RUN = 0, // with options dlg
            PREVIEW_RUN = 1, // no options dlg, direct to Preview
            QUICK_RETURN_RUN = 2 // no options dlg, direct break and return
        };

        /// Mirrors hkdShape::BodyQualityType
        enum QualityTypes
        {
            QUALITY_INHERITED,
            QUALITY_FIXED,
            QUALITY_DEBRIS,
            QUALITY_DEBRIS_SIMPLE_TOI,
            QUALITY_MOVING,
            QUALITY_CRITICAL,
        };

        /// Info about a broken piece
        struct BodyInfo
        {
            /// Destructor
            virtual ~BodyInfo();

            /// Gets / Sets the parent of the new piece
            virtual hkxNode* getOriginalNode() = 0;
            virtual void setOriginalNode(hkxNode* o) = 0;

            // The geometric shape, transform and name for the graphics body, can also be
            // the physics body depending on whether there are child shapes. If no child shapes then just a convex hull.
            virtual hkMeshBody* getGraphicsBody() = 0;

            // if empty, just use graphics body. Else use these as a convexlist shape.
            // They may have a transform, so a convex transform shape around a convex hull.
            virtual void getPhysicsShapes(hkArray<hkMeshBody*>& s) = 0;

            /// Returns the parent index
            virtual int getParentIndex() = 0;

            /// Returns the quality type
            virtual QualityTypes getQualityType() const = 0;
        };

    public:

        /// Destructor
        virtual ~hctDestructionUtils();

    public:

        /// Sets the filter manager path
        virtual void setFilterManagerPath(const char* path) = 0;

        /// Register the thread callback
        virtual void registerThreadCallback(const class hctFilterThreadCallback* cb)= 0;

        // As pure virtual, any calls will result in proper DLL scope, without use import/export/delay loads etc
        // Delete BodyInfo when done
        virtual void breakObjects( hkRootLevelContainer* scene, hkxNode** objectsToBreak, int numObjects, hkArray< BodyInfo* >& brokenPieces, void* ownerHwnd, RunOptions options ) = 0;

        virtual void setInitSettingsFilename(const char* f) = 0;
        virtual void setPreviewSettingsFilename(const char* f) = 0;
        virtual const char* getInitSettingsFilename() const = 0;
        virtual const char* getPreviewSettingsFilename() const = 0;

        virtual void setDistanceConversionFactor(hkReal distanceConversionfactor) = 0;

        virtual class hctFilterProcessingUtil* getFilterUtil() = 0;
};

typedef class hctBaseDll* (HK_CALL *hctGetBaseDllInterfaceFunc)();
typedef hctDestructionUtils* (HK_CALL *hctGetDestructionUtilInterfaceFunc)();
typedef hctDestructionUtils::DllError (HK_CALL *hctGetDestructionDllErrorFunc)();

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
