// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT      : CONVEX_DECOMPOSITION+PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Geometry/ConvexDecomposition/hkgpConvexDecomposition.h>

//
// Progress bar, implements interface in hkgpConvexDecomposition
//
struct hctConvexDecompProgress : public hkgpConvexDecomposition::IProgress
{
public:
    hctConvexDecompProgress(){ m_progressJobHandler = 0; }
    ~hctConvexDecompProgress(){}

    // These functions are called from the convex decomposition code, and add jobs to update the progress bar.
    bool startJob ( int index, int totalJobs ) const;
    void endJob() const;
    bool didUserCancel() const;
    bool onDecomposePlanes( int currentPlane, int totalPlanes ) const;
    bool onReduce( int currentHullCount, int totalHulls ) const;
    bool onDecimate( int currentHullCount, int objectiveHullsCount ) const;

    mutable hctConvexDecompProgressHandler*     m_progressJobHandler;
    mutable bool                                m_areSeparateDecompositions;
    int                                         m_nOrigHulls;
};

//
// Convex decomposition utility implementation, calls hkgpConvexDecomposition functionality
//
class hctConvexDecompUtilsImpl : public hctConvexDecompUtils
{
public:

    hctConvexDecompUtilsImpl();
    virtual ~hctConvexDecompUtilsImpl();

    virtual void setThreadCallback( hkSceneExportMemThreadCallback* callback ){ m_threadCallback = callback; }

    virtual bool decompose( const hctConvexDecompUtils::Input& input, const hkGeometry& geometry, hkArray<hkArray<hkVector4> >& shapesOut );
    virtual bool combine( const hctConvexDecompUtils::Input& input, const hkGeometry& geometry, hkArray< hkArray< hkVector4 > >& shapesOut, hkArray< hkArray< hkVector4 > >* shapesToCombine );

    virtual void createConvexGeometry( hkArray< hkVector4 >& shape, hkGeometry& shapeGeometry );
    virtual int getConvexHullPlanes( const hkGeometry& geometry );
    virtual void mergeGeometries(const hkGeometry& input,hkGeometry& output);
    virtual hkReal normalizeGeometry( hkGeometry& geom, hkReal size, hkTransform* normalizedToWorld, hkVector4* normalizeCenter );
    virtual void normalizeShapes( hkArray< hkArray< hkVector4 > >& shapes, hkReal scale, hkVector4& normalizeCenter );

protected:
    hkSceneExportMemThreadCallback* m_threadCallback;
};

__declspec(dllexport) class hctBaseDll* HK_CALL getBaseDllInterface();
__declspec(dllexport) hctConvexDecompUtils* HK_CALL getConvexDecompUtilInterface();
__declspec(dllexport) hctConvexDecompUtils::DllError HK_CALL getConvexDecompDllError();

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
