// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/System/Log/hkLog.h>
#include <Common/Base/Container/Hash/hkHashMap.h>
#include <Common/Base/System/Error/hkDefaultError.h>

class hkServerTextHandler;
class DeferredOutputFwd;

/// This class facilitates reporting of hkError and hkLog messages to the vdb client.
class HK_EXPORT_COMMON hkVisualDebuggerReporter : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS(hkVisualDebuggerReporter, New);

        /// Create a reporter which reports to the provided text handler.
        hkVisualDebuggerReporter( hkServerTextHandler& handler );
        virtual ~hkVisualDebuggerReporter();

        /// Interface to be used with the reporter to output error and log messages.
        class HK_EXPORT_COMMON Output
        {
        public:
            virtual hkResult outputText( hkUint64 id, hkLog::Level::Enum level, const char* text, int tag = 0 ) = 0;
            virtual hkResult flush() { return HK_SUCCESS; }
        };

        /// hkError interface which forwards to an Output object
        /// with some default formatting applied.
        class HK_EXPORT_COMMON ErrorReporter : public hkDefaultError
        {
        public:
            HK_DECLARE_CLASS( ErrorReporter, New );
            ErrorReporter( hkVisualDebuggerReporter::Output& output );
            virtual hkBool isEnabled( int id ) HK_OVERRIDE;
            virtual Message getMinimumMessageLevel() HK_OVERRIDE;
            void reportDisabledMessages( hkBool32 on );
            hkBool32 isReportingDisabledMessages() const;
            static hkLog::Level::Enum getMessageLogLevel( hkError::Message msg );
        protected:
            virtual void showMessage( hkError::Message msg, int id, _In_z_ const char* desc, _In_z_ const char* file, int line ) const HK_OVERRIDE;
            hkVisualDebuggerReporter::Output& m_output;
            hkBool32 m_reportDisabledMessages;
        };

        /// hkLog::Output interface which forwards to an Output object
        /// with some default formatting applied.
        class HK_EXPORT_COMMON LogReporter : public hkLog::TextOutput
        {
        public:
            HK_DECLARE_CLASS( LogReporter, New );
            LogReporter( hkVisualDebuggerReporter::Output& output );
            virtual hkLog::Output::Action put( const hkLog::Message& msg ) override;
        protected:
            hkVisualDebuggerReporter::Output& m_output;
        };

        /// Get the reporter forwarding messages from the hkError system.
        class ErrorReporter* getErrorReporter() const { return m_reporterError; }

        /// Get the reporter forwarding messages from the hkLog system.
        class LogReporter* getLogReporter() const { return m_reporterLogOutput; }

        /// Set a maximum level for reporting stack traces (hkError message types are converted).
        void setMaximumStackTraceLevel( hkLog::Level::Enum lvl );

        /// Get the maximum level for reporting stack traces (hkError message types are converted).
        hkLog::Level::Enum getMaximumStackTraceLevel();

        /// Flush the contents to the output provided in the ctor.
        void flush();

    protected:

        DeferredOutputFwd* m_deferredOutputFwd;
        ErrorReporter* m_reporterError;
        LogReporter* m_reporterLogOutput;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
