// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkStreamWriter;
class hkStreamReader;




//////////////////////////////////////////////////////////////////////////
/// Enum describing different types of vdb commands.  See docs for more details.
/// The value spaces are laid out as follows:
/// (-1/255) - (-2/254)      - 0 ----------------------------------------------------------------- | ------------------------------------- 253
/// INVALID  - ERROR_MESSAGE - STEP/STEP_ACK --> MAX_SERVER_TO_CLIENT_CMD/MAX_CLIENT_TO_SERVER_CMD | DEPRECATED_START <-- DEPRECATED_END - CLIENT_TO_CLIENT_START
/// Note: some of these are not yet implemented, but reserved for future use.
//////////////////////////////////////////////////////////////////////////
namespace hkVdbCmdType
{
    enum Enum
    {
        //////////////////////////////////////////////////////////////////////////
        // Server -> Client (grow from zero toward max value)
        //////////////////////////////////////////////////////////////////////////

        //
        // Framework
        //
        
        
        
        
        
        ERROR_MESSAGE = hkUint8( -2 ),
        INVALID = hkUint8( -1 ),
        STEP = 0,
        SEND_SERVER_INFO = 1,
        CUSTOM = 2,
        CUSTOM_PERSIST = 3,
        CUSTOM_DEPENDENT = 4,
        

        //
        // Display Handler
        //
        SET_DISPLAY_OPTIONS,

        // Persistent Geometry
        // Note: changing these requires a rebuild of hkVdbServices for the Vdb to function properly
        ADD_GEOMETRY,
        ADD_GEOMETRY_EX,
        INSTANCE_GEOMETRY,
        UPDATE_GEOMETRY,
        UPDATE_GEOMETRY_TRANSFORM,
        UPDATE_GEOMETRY_TRANSFORM_EX,
        UPDATE_PARTICLE_TRANSFORMS,
        UPDATE_GEOMETRY_VERTICES,
        SET_GEOMETRY_COLOR,
        SET_GEOMETRY_ALPHA,
        SET_GEOMETRY_FLAG_BITS,
        CLEAR_GEOMETRY_FLAG_BITS,
        REMOVE_GEOMETRY,

        // Temporary Display
        DISPLAY_GEOMETRY,
        DISPLAY_POINT,
        DISPLAY_POINT_EX,
        DISPLAY_2_POINTS,
        DISPLAY_2_POINTS_EX,
        DISPLAY_3_POINTS,
        DISPLAY_3_POINTS_EX, 
        DISPLAY_TEXT, 
        DISPLAY_3D_TEXT,
        FLUSH_DISPLAY,

        // Camera
        UPDATE_CAMERA,
        REMOVE_CAMERA,

        //
        // Object Handler
        //
        REGISTER_OBJECT_TYPE,
        ADD_OBJECTS,
        UPDATE_OBJECTS,
        REMOVE_OBJECTS,
        CONNECT_OBJECTS,
        DISCONNECT_OBJECTS,

        //
        // Playback Handler
        //
        SET_CLIENT_PLAYBACK_STATE,
        SET_CLIENT_PLAYBACK_FRAME,
        SAVE_REPLAY,

        //
        // Process Handler
        //
        REGISTER_PROCESS,
        REGISTER_PROCESS_EX, 
        UPDATE_PROCESS, 
        SELECT_PROCESS,
        UNSELECT_PROCESS,

        //
        // Setup Handler
        //
        // Handles SEND_SERVER_INFO command

        //
        // Stats Handler
        //
        SEND_PERF_STATS,
        SEND_MEM_STATS,
        SEND_STATS_MAPS,

        //
        // Text Handler
        //
        LOG_TEXT, 

        //
        // File Handler
        //
        SEND_FILE,

        //
        // Sentinel
        //
        MAX_SERVER_TO_CLIENT_CMD,

        //////////////////////////////////////////////////////////////////////////
        // Client -> Server (grow from zero toward max value)
        //////////////////////////////////////////////////////////////////////////

        //
        // Framework
        //
        
        
        
        
        
        STEP_ACK = STEP,
        CUSTOM_SERVER_CONTROL = CUSTOM,

        //
        // Process Handler
        //
        CREATE_PROCESS,
        DELETE_PROCESS,
        TWEAK_PROCESS, 

        //
        // Object Handler
        //
        //TWEAK_DATA, 

        //
        // Grabbing
        //
        GRAB_GEOMETRY,
        DRAG_GEOMETRY,
        RELEASE_GEOMETRY,

        //
        // Input
        //
        
        //SEND_KEY_DOWN,
        //SEND_KEY_UP,
        //SEND_BUTTON_DOWN,
        //SEND_BUTTON_UP,

        //
        // Sentinel
        //
        MAX_CLIENT_TO_SERVER_CMD,

        //////////////////////////////////////////////////////////////////////////
        // Client side only (for implementation-specific use)
        //////////////////////////////////////////////////////////////////////////

        //
        // Framework
        //
        
        
        
        
        
        CLIENT_TO_CLIENT_START = 253,
        CLIENT_INTERNAL = CLIENT_TO_CLIENT_START,

        //
        // Sentinel
        //
        MAX_CLIENT_TO_CLIENT_CMD,

        //////////////////////////////////////////////////////////////////////////
        // Deprecated (these will be removed in a later release)
        //////////////////////////////////////////////////////////////////////////

        DEPRECATED_END = ( CLIENT_TO_CLIENT_START - 1 ),
        DEPRECATED_ADD_RIGID_GEOMETRY = ( DEPRECATED_END - 0 ),
        DEPRECATED_ADD_RIGID_GEOMETRY_EX = ( DEPRECATED_END - 1 ),
        DEPRECATED_ADD_MORPHING_GEOMETRY = ( DEPRECATED_END - 2 ),
        DEPRECATED_ADD_MORPHING_GEOMETRY_EX = ( DEPRECATED_END - 3 ),
        DEPRECATED_ADD_FIXED_GEOMETRY = ( DEPRECATED_END - 4 ),
        DEPRECATED_ADD_FIXED_GEOMETRY_EX = ( DEPRECATED_END - 5 ),
        DEPRECATED_DISPLAY_GEOMETRY = ( DEPRECATED_END - 6 ),
        DEPRECATED_LIVE_OBJECT = ( DEPRECATED_END - 7 ),
        DEPRECATED_MEMORY_SNAPSHOT = ( DEPRECATED_END - 8 ),
        DEPRECATED_WORLD_SNAPSHOT = ( DEPRECATED_END - 9 ),
        DEPRECATED_SEND_STATISTICS_DUMP = ( DEPRECATED_END - 10 ),
        DEPRECATED_ADD_GEOMETRY_HASH = ( DEPRECATED_END - 11 ),
        DEPRECATED_ADD_GEOMETRY_HASH_FINAL = ( DEPRECATED_END - 12 ),
        DEPRECATED_REQUEST_GEOMETRY_WITH_HASH = ( DEPRECATED_END - 13 ),
        DEPRECATED_DONT_REQUEST_GEOMETRY_WITH_HASH = ( DEPRECATED_END - 14 ),
        DEPRECATED_ADD_GEOMETRY_PART = ( DEPRECATED_END - 15 ),
        DEPRECATED_ADD_GEOMETRY_FINAL = ( DEPRECATED_END - 16 ),
        DEPRECATED_START = DEPRECATED_DONT_REQUEST_GEOMETRY_WITH_HASH
    };

    /// Specifies the directon of a vdb command.
    struct HK_EXPORT_COMMON Direction
    {
        enum Enum
        {
            SERVER_TO_CLIENT,
            CLIENT_TO_SERVER
        };
    };

    /// Patch a type value from the server to it's current type value based on provided protocol.
    /// If protocol is less than or equal to zero, this will return INVALID unless type is a known
    /// protocol cmd setting type value which is patched to SEND_SERVER_INFO.
    template<Direction::Enum>
    Enum patchType( int protocol, int type );

    /// Write a cmd error into a stream.
    /// Cmd errors are unrecoverable errors that cause the cmd dispatcher to fail and cease to
    /// process further cmds. This is useful to avoid crash scenarios caused by a corrupt stream.
    /// Use carefully.
    void writeErrorCmd( hkStreamWriter& writer, hkUint32 id, const char* message );

    /// Read a cmd error that was written into a stream by writeCmdError.
    /// It's expected that the reader is ready to read cmd data.
    void readErrorCmd( hkStreamReader& reader, hkUint32& idOut, hkStringBuf& messageOut );
}

/// Dedicated sub-type value spaces for use with CUSTOM, CUSTOM_PERSIST, CUSTOM_DEPENDENT.
/// Based on a max value for hkUint16.
namespace hkVdbCustomCmdType
{
    const int CUSTOM_CMD_TYPE_RESERVE_BLOCK_SIZE = 0x17ff;
    enum Enum
    {
        COMMON_CMD_START = 0,
        PHYSICS_CMD_START = CUSTOM_CMD_TYPE_RESERVE_BLOCK_SIZE,
        AI_CMD_START = ( CUSTOM_CMD_TYPE_RESERVE_BLOCK_SIZE * 2 ),
        CLOTH_CMD_START = ( CUSTOM_CMD_TYPE_RESERVE_BLOCK_SIZE * 3 ),
        DESTRUCTION_CMD_START = ( CUSTOM_CMD_TYPE_RESERVE_BLOCK_SIZE * 4 ),
        
        USER_CMD_START = ( CUSTOM_CMD_TYPE_RESERVE_BLOCK_SIZE * 8 ),
        MAX_CUSTOM_CMD = ( 1 << sizeof( hkUint16 ) * 8 ) - 1
    };
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
