// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/hkVisualDebuggerCmdType.h>

#include <Common/Visualize/hkVisualDebuggerCmd.h>
#include <Common/Visualize/hkVersionReporter.h>
#include <Common/Visualize/Serialize/hkVdbIStream.h>
#include <Common/Visualize/Serialize/hkVdbOStream.h>

#define TYPES_INSERTED_AT( PROTOCOL, INDEX, NUM_TYPES ) { PROTOCOL, INDEX, +( NUM_TYPES ) }
#define TYPE_INSERTED_AT( PROTOCOL, INDEX ) TYPES_INSERTED_AT( ( PROTOCOL ), ( INDEX ), 1 )
#define TYPES_REMOVED_AT( PROTOCOL, INDEX, NUM_TYPES ) { PROTOCOL, INDEX, -( NUM_TYPES ) }
#define TYPE_REMOVED_AT( PROTOCOL, INDEX ) TYPES_REMOVED_AT( ( PROTOCOL ), ( INDEX ), 1 )

struct TypePatch
{
    int m_protocol;
    int m_index;
    int m_adjustment;
};

TypePatch patches[] = {

    // Example
    // Note: Protocol must always be increasing
    //TYPE_INSERTED_AT( 16400, 7 ),
    //TYPE_REMOVED_AT( 16400, 11 ),
    //TYPES_INSERTED_AT( 17100, 24, 3 ),
    //TYPES_REMOVED_AT( 17200, 57, 2 ),

    { 0, 0, 0 }, 
};

// If these asserts hit, you need to make sure you write a TypePatch
HK_COMPILE_TIME_ASSERT( hkVdbCmdType::MAX_SERVER_TO_CLIENT_CMD == 50 );
HK_COMPILE_TIME_ASSERT( hkVdbCmdType::MAX_CLIENT_TO_SERVER_CMD == 9 );
HK_COMPILE_TIME_ASSERT( hkVdbCmdType::CLIENT_TO_CLIENT_START == 253 );

int applyPatch20171( int type );
int applyReversePatch20171( int type );

namespace hkVdbCmdType
{
    template<>
    Enum patchType<Direction::SERVER_TO_CLIENT>( int protocol, int type )
    {
        HK_ASSERT_DEV( 0x22440873, ( type >= 0 ) && ( type <= 255 ), "Type is out of expected range" );

        if ( protocol <= 0 )
        {
            // Note:
            //
            // Before the refactor, the version information command type had a value of 144 (explicitly assigned).
            // Also, we only had roughly 57 unique Client->Server commands.
            // The refactor compacted the current list of commands and created a "patching" framework for
            // later adjustments so these arbitrary gaps in the command type values would no longer be necessary.
            // Therefore, if we have a command type of 144 after the refactor, we've grown considerably in our
            // number of unique commands.
            // We also check that the protocol number we get is valid after we deserialize the protocol-setting cmd.
            // In order for corrupt behavior to happen here someone would need to:
            // - create a new cmd with value 144
            // - that cmd's first 32-bits of data would need to be a valid protocol number
            // - they'd have to change hkVisualDebugger::createClient to *not* send version information as the first cmd.
            // This seems extremely unlikely and by the time we get up to 144 commands, hopefully we can remove this
            // deprecated handling all together.
            //
            // Note: we actually have a similar problem with the leading DEBUG_TAG in files from 2016.1
            // where the file starts with a DEBUG_TAG which is a CLIENT_INTERNAL cmd. We don't know the protocol
            // yet, so we return INVALID.  Since that tag is just to put strings in the file format, this is fine.
            // and rather than risking interpreting 255 as CLIENT_INTERNAL here (and possibly crashing on someone
            // trying to interpret a corrupt cmd as CLIENT_INTERNAL), we just allow it to be INVALID.
            if ( ( type == SEND_SERVER_INFO ) || ( type == 0x90 ) )
            {
                return SEND_SERVER_INFO;
            }
            else
            {
                return INVALID;
            }
        }
        else if ( protocol < hkProtocolVersion::VDB_2017_1 )
        {
            // Patch is based on table which uses current values from old
            type = applyPatch20171( type );
        }
        else if ( type < DEPRECATED_END )
        {
            HK_ON_DEBUG( hkBool32 isDeprecated = ( type >= DEPRECATED_START ) && ( type <= DEPRECATED_END ); )

            // Patch is done based on patch operations
            for ( int i = 0; i < HK_COUNT_OF( patches ); i++ )
            {
                TypePatch& patch = patches[i];
                if ( protocol < patch.m_protocol )
                {
                    // Apply adjustment
                    type += ( type >= patch.m_index ) * patch.m_adjustment;

                    // Check for removal of this command
                    if ( ( patch.m_adjustment < 0 ) && ( type < patch.m_index ) )
                    {
                        return INVALID;
                    }
                }
            }

            HK_ASSERT_DEV(
                0x22440865,
                isDeprecated || ( ( type < DEPRECATED_START ) || ( type > DEPRECATED_END ) ),
                "Type has overlapped with deprecated region" );
        }

        HK_ASSERT_DEV( 0x22440876, ( type >= 0 ) && ( type <= 255 ), "Type is out of expected range" );

        return Enum( type );
    }

    template<>
    Enum patchType<Direction::CLIENT_TO_SERVER>( int protocol, int type )
    {
        HK_ASSERT_DEV( 0x22440873, ( type >= 0 ) && ( type <= 255 ), "Type is out of expected range" );

        if ( protocol <= 0 )
        {
            return INVALID;
        }
        else if ( protocol < hkProtocolVersion::VDB_2017_1 )
        {
            // Patch is based on table which uses current values from old
            type = applyReversePatch20171( type );
        }
        else if ( type < DEPRECATED_END )
        {
            // Patch is done based on patch operations
            for ( int i = HK_COUNT_OF( patches ) - 1; i >= 0 ; i-- )
            {
                TypePatch& patch = patches[i];
                if ( protocol < patch.m_protocol )
                {
                    // Apply adjustment
                    type -= ( type >= patch.m_index ) * patch.m_adjustment;

                    // Check for removal of this command
                    if ( ( patch.m_adjustment < 0 ) && ( type < patch.m_index ) )
                    {
                        return INVALID;
                    }
                }
            }
        }

        HK_ASSERT_DEV( 0x22440876, ( type >= 0 ) && ( type <= 255 ), "Type is out of expected range" );

        return Enum( type );
    }

    void writeErrorCmd( hkStreamWriter& writer, hkUint32 id, const char* message )
    {
        using namespace hkVdbCmdUtils;
        const int packetSize = s8 + s32 + hkString::strLen( message ) + s8;
        hkVdbOStream ostream( &writer );
        ostream.write32u( packetSize );
        ostream.write8u( ERROR_MESSAGE );
        ostream.write32u( id );
        ostream.writeString( message );
    }

    void readErrorCmd( hkStreamReader& reader, hkUint32& idOut, hkStringBuf& messageOut )
    {
        hkVdbIStream istream( &reader );
        idOut = istream.read32u();
        istream.readString( messageOut );
    }
}

//////////////////////////////////////////////////////////////////////////
// Large refactor, uses lookup tables to do translation
//////////////////////////////////////////////////////////////////////////

// The 2016.1 values for reference
#if 0
namespace hkVisualDebuggerProtocol
{
    enum ServerToClientCommands
    {
        HK_STEP = 0x00,
        HK_ADD_GEOMETRY,
        HK_UPDATE_GEOMETRY,
        HK_SET_COLOR_GEOMETRY,
        HK_REMOVE_GEOMETRY,
        HK_DISPLAY_GEOMETRY_WITH_TRANSFORM,
        HK_DISPLAY_GEOMETRY,
        HK_DISPLAY_POINT,
        HK_DISPLAY_LINE,
        HK_DISPLAY_TEXT,
        HK_SEND_STATISTICS_DUMP,
        HK_HOLD_IMMEDIATE,
        HK_ADD_CAMERA,
        HK_UPDATE_CAMERA,
        HK_REMOVE_CAMERA,
        HK_SEND_MEMSTATS_DUMP,
        HK_ADD_GEOMETRY_INSTANCE,
        HK_DISPLAY_TEXT_3D,
        HK_SET_GEOMETRY_PICKABLE,
        HK_DISPLAY_THICK_POINT,
        HK_DISPLAY_ANNOTATION,
        HK_ADD_MESH_OBSOLETE,
        HK_REMOVE_MESH_OBSOLETE,
        HK_UPDATE_GEOMETRY_WITH_SCALE,
        HK_SKIN_GEOMETRY,
        HK_ADD_GEOMETRY_PART,
        HK_ADD_GEOMETRY_FINAL,
        HK_ADD_GEOMETRY_HASH,
        HK_GEOMETRY_FOR_HASH_PART,
        HK_GEOMETRY_FOR_HASH_FINAL,
        HK_DISPLAY_BONE,
        HK_SET_TRANSPARENCY_GEOMETRY,
        HK_SETUP = 0x20,
        HK_VERSION_INFORMATION = 0x90,
        HK_SERVER_LAYOUT,
        HK_REGISTER_PROCESS = 0xC0,
        HK_SELECT_PROCESS = 0xC1,
        HK_PAUSE_WORLD_STEP = 0xC4,
        HK_UNPAUSE_WORLD_STEP = 0xC5,
        HK_SNAPSHOT = 0xD0,
        MEMORY_SNAPSHOT = 0xD1,
        HK_ADD_DYNAMIC_VERTICES_GEOMETRY,
        HK_UPDATE_GEOMETRY_VERTS,
        HK_SEND_VERSIONED_STATISTICS_DUMP,
        HK_SEND_VERSIONED_MEMSTATS_DUMP,
        HK_ADD_DYNAMIC_VERTICES_GEOMETRY_EXTENDED,
        HK_ADD_GEOMETRY_EXTENDED,
        HK_ADD_STATIC_GEOMETRY,
        HK_ADD_STATIC_GEOMETRY_EXTENDED,
        HK_DISPLAY_TRIANGLE,
        HK_SEND_VERSIONED_STAT_MAPS,
    };

    enum BidirectionalCommands
    {
        HK_ADD_TOPLEVEL = 0x21,
        HK_REMOVE_TOPLEVEL,
        HK_REQUEST_OBJECT,
        HK_ADD_OBJECT,
        HK_UPDATE_MEMBER,
        HK_LIVE_OBJECT = 0x40,
    };

    enum ClientToServerCommands
    {
        COMMAND_STEP = 0x00,
        COMMAND_REQUEST_GEOMETRY_WITH_HASH = 0x30,
        COMMAND_DO_NOT_REQUEST_GEOMETRY_WITH_HASH = 0x31,
        COMMAND_CLIENT_DISPLAY_HANDLER_SETTINGS = 0x32,
        HK_PICK_OBJECT = 0xB0,
        HK_DRAG_OBJECT = 0xB1,
        HK_RELEASE_OBJECT = 0xB2,
        HK_CREATE_PROCESS = 0xC2,
        HK_DELETE_PROCESS = 0xC3,
        COMMAND_ACK = 0xF0,
    };

    enum ServerOnlyCommands
    {
        HK_CUSTOM_SERVER_COMMAND = 0xFF
    };
}
#endif

using namespace hkVdbCmdType;

// Note: Previous cmd values didn't have overlap between
// Server -> Client and Client -> Server commands
int s_patchTable20171[256] =
{
    // Server -> Client
    STEP, //HK_STEP/COMMAND_STEP = 0x00,
    DEPRECATED_ADD_RIGID_GEOMETRY, //HK_ADD_GEOMETRY,
    UPDATE_GEOMETRY_TRANSFORM, //HK_UPDATE_GEOMETRY,
    SET_GEOMETRY_COLOR, //HK_SET_COLOR_GEOMETRY,
    REMOVE_GEOMETRY, //HK_REMOVE_GEOMETRY,
    DISPLAY_GEOMETRY, //HK_DISPLAY_GEOMETRY_WITH_TRANSFORM,
    DEPRECATED_DISPLAY_GEOMETRY, //HK_DISPLAY_GEOMETRY,
    DISPLAY_POINT, //HK_DISPLAY_POINT,
    DISPLAY_2_POINTS, //HK_DISPLAY_LINE,
    DISPLAY_TEXT, //HK_DISPLAY_TEXT,
    DEPRECATED_SEND_STATISTICS_DUMP, //HK_SEND_STATISTICS_DUMP,
    INVALID, //HK_HOLD_IMMEDIATE, wasn't actually used
    INVALID, //HK_ADD_CAMERA, wasn't actually used
    UPDATE_CAMERA, //HK_UPDATE_CAMERA,
    INVALID, //HK_REMOVE_CAMERA, wasn't actually used
    INVALID, //HK_SEND_MEMSTATS_DUMP, wasn't supported for awhile
    INSTANCE_GEOMETRY, //HK_ADD_GEOMETRY_INSTANCE,
    DISPLAY_3D_TEXT, //HK_DISPLAY_TEXT_3D,
    INVALID, //HK_SET_GEOMETRY_PICKABLE, not going to liter protocol with a handler for this, it's been superseded by SET_GEOMETRY_FLAG_BITS
    DISPLAY_POINT_EX, //HK_DISPLAY_THICK_POINT,
    INVALID, //HK_DISPLAY_ANNOTATION, used by Destruction, superseded by LOG_TEXT
    INVALID, //HK_ADD_MESH_OBSOLETE,
    INVALID, //HK_REMOVE_MESH_OBSOLETE,
    UPDATE_GEOMETRY_TRANSFORM_EX, //HK_UPDATE_GEOMETRY_WITH_SCALE,
    INVALID, //HK_SKIN_GEOMETRY, was only used by Behavior
    DEPRECATED_ADD_GEOMETRY_PART, //HK_ADD_GEOMETRY_PART, deprecated
    DEPRECATED_ADD_GEOMETRY_FINAL, //HK_ADD_GEOMETRY_FINAL, deprecated
    INVALID, //HK_ADD_GEOMETRY_HASH, deprecated
    INVALID, //HK_GEOMETRY_FOR_HASH_PART, deprecated
    INVALID, //HK_GEOMETRY_FOR_HASH_FINAL, deprecated
    INVALID, //HK_DISPLAY_BONE, was only used by Behavior
    SET_GEOMETRY_ALPHA, //HK_SET_TRANSPARENCY_GEOMETRY,
    INVALID, //HK_SETUP = 0x20, old object inspection system is deprecated
    INVALID, //HK_ADD_TOPLEVEL = 0x21, old object inspection system is deprecated
    INVALID, //HK_REMOVE_TOPLEVEL, old object inspection system is deprecated
    INVALID, //HK_REQUEST_OBJECT, old object inspection system is deprecated
    INVALID, //HK_ADD_OBJECT, old object inspection system is deprecated
    INVALID, //HK_UPDATE_MEMBER, old object inspection system is deprecated
    // [38 - 47] are empty
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,

    // Client -> Server
    INVALID, //COMMAND_REQUEST_GEOMETRY_WITH_HASH = 0x30, deprecated
    INVALID, //COMMAND_DO_NOT_REQUEST_GEOMETRY_WITH_HASH = 0x31, deprecated
    INVALID, //COMMAND_CLIENT_DISPLAY_HANDLER_SETTINGS = 0x32, deprecated
    // [51 - 143] are empty (except 64 for HK_LIVE_OBJECT which is no longer valid)
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    INVALID, INVALID, INVALID,
    SEND_SERVER_INFO, //HK_VERSION_INFORMATION = 0x90,
    INVALID, //HK_SERVER_LAYOUT, redundant (was already included in HK_VERSION_INFORMATION)
    // [146 - 175] are empty
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    GRAB_GEOMETRY, //HK_PICK_OBJECT = 0xB0,
    DRAG_GEOMETRY, //HK_DRAG_OBJECT = 0xB1,
    RELEASE_GEOMETRY, //HK_RELEASE_OBJECT = 0xB2,
    // [179 - 191] are empty
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    INVALID, INVALID, INVALID,
    REGISTER_PROCESS, //HK_REGISTER_PROCESS = 0xC0,
    SELECT_PROCESS, //HK_SELECT_PROCESS = 0xC1,
    CREATE_PROCESS, //HK_CREATE_PROCESS = 0xC2,
    DELETE_PROCESS, //HK_DELETE_PROCESS = 0xC3,
    INVALID, //HK_PAUSE_WORLD_STEP = 0xC4, wasn't implemented in released version, superseded by playback handler command SET_CLIENT_PLAYBACK_STATE
    INVALID, //HK_UNPAUSE_WORLD_STEP = 0xC5, wasn't implemented in released version, superseded by playback handler command SET_CLIENT_PLAYBACK_STATE
    // [198 - 207] are empty
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    DEPRECATED_WORLD_SNAPSHOT, //HK_SNAPSHOT = 0xD0, superseded by SEND_FILE
    DEPRECATED_MEMORY_SNAPSHOT, //MEMORY_SNAPSHOT = 0xD1, superseded by SEND_FILE
    DEPRECATED_ADD_MORPHING_GEOMETRY, //HK_ADD_DYNAMIC_VERTICES_GEOMETRY,
    UPDATE_GEOMETRY_VERTICES, //HK_UPDATE_GEOMETRY_VERTS,
    SEND_PERF_STATS, //HK_SEND_VERSIONED_STATISTICS_DUMP,
    INVALID, //HK_SEND_VERSIONED_MEMSTATS_DUMP, disabled since 2015.1 and used hkMonitors, which we won't carry going fwd.
    DEPRECATED_ADD_MORPHING_GEOMETRY_EX, //HK_ADD_DYNAMIC_VERTICES_GEOMETRY_EXTENDED,
    DEPRECATED_ADD_RIGID_GEOMETRY_EX, //HK_ADD_GEOMETRY_EXTENDED,
    DEPRECATED_ADD_FIXED_GEOMETRY, //HK_ADD_STATIC_GEOMETRY,
    DEPRECATED_ADD_FIXED_GEOMETRY_EX, //HK_ADD_STATIC_GEOMETRY_EXTENDED,
    DISPLAY_3_POINTS, //HK_DISPLAY_TRIANGLE,
    SEND_STATS_MAPS, //HK_SEND_VERSIONED_STAT_MAPS,
    // [220 - 239] None
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    STEP_ACK, //COMMAND_ACK = 0xF0,
    // [241 - 254] None
    INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID, INVALID,
    INVALID, INVALID, INVALID, INVALID,
    CLIENT_INTERNAL //HK_CUSTOM_SERVER_COMMAND = 0xFF
};

int applyPatch20171( int type )
{
    return s_patchTable20171[type];
}

int applyReversePatch20171( int type )
{
    if ( type == STEP_ACK )
    {
        return 0xF0;
    }
    else if ( type == CREATE_PROCESS )
    {
        return 0xC2;
    }
    else if ( type == DELETE_PROCESS )
    {
        return 0xC3;
    }
    else if ( type == GRAB_GEOMETRY )
    {
        return 0xB0;
    }
    else if ( type == DRAG_GEOMETRY )
    {
        return 0xB1;
    }
    else if ( type == RELEASE_GEOMETRY )
    {
        return 0xB2;
    }
    else
    {
        return hkVdbCmdType::INVALID;
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
