// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Config/hkConfigVersion.h>

class hkStreamWriter;
class hkStreamReader;
class hkVdbIStream;

//////////////////////////////////////////////////////////////////////////
/// Protocol Revision Information
/// Extensions to the protocol do not necessarily make the the client
/// and server incompatible.
///
/// Client can support more packets then the server is able to send...
/// Server can send packets and the client can ignore them.
/// Visa-versa for both of the above.
///
/// The client can also be written to version old packets.
//////////////////////////////////////////////////////////////////////////
namespace hkProtocolVersion
{
    /// The minimum supported version
    static const int MINIMUM = 2300;

    /// The current version
    static const int CURRENT = HAVOK_VDB_VERSION;

    /// Added more ids to some cmds
    static const int MORE_CMD_IDS_700 = 7000;

    /// The first version with support for sending compiler strings as part of the version message.
    static const int SUPPORTS_COMPILER_STRING = 7001;

    /// Added host layout rules to the HK_VERSION_INFORMATION, to support a 64 bit VDB
    static const int CONTAINS_HOST_LAYOUT_RULES = 14200;

    /// New reflection changes:
    /// Changed stats frameinfo etc and parsing, read as XYY -> vX.YY
    /// New serialize/deserialize of monitor string tables
    static const int REFLECTION_2015_1 = 15100;

    /// We now support a circular buffer of cmds.
    static const int SUPPORTS_CIRCULAR_BUFFER = 16100;

    /// New VDB is released, numerous changes.
    static const int VDB_2017_1 = 17100;

    /// Authentication added to connection establishment.
    static const int SUPPORTS_CONNECTION_AUTHENTICATION = 17200;

    
    
    
    
    
    
    
    
    
    
}

//////////////////////////////////////////////////////////////////////////
/// This class reports platform information about the server to the client.

//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_COMMON hkVersionReporter
{
    public:

        /// Platform information struct
        struct Info
        {
            HK_DECLARE_CLASS( Info, New );
            Info() : m_protocol( -1 ) {}
            int m_protocol;
            int m_minimumProtocol;
            int m_sdkVersion;
            hkStringPtr m_platformString;
            hkStringPtr m_compilerString;
            hkUint8 m_sizeOfPointer;
            bool m_isLittleEndian;
        };

        /// Sends cmd containing data about the server such as protocol version.
        /// If authenticationHash is non-zero, computes an ack which the client will compute and send back.
        static hkResult HK_CALL writeServerInformationCmd(
            hkStreamWriter* connection,
            hkUint64 authenticationHash,
            hkUint64& authenticationHashAckOut );

        /// Read server information from a stream pointing to cmd data.
        /// Returns an authentication ack which should be sent back to the server if non-zero.
        static hkResult HK_CALL readServerInformationCmdData(
            hkStreamReader* connection,
            Info& infoOut,
            hkUint64& authenticationHashAckOut );
        static hkResult HK_CALL readServerInformationCmdData(
            hkVdbIStream& chunkStream,
            Info& infoOut,
            hkUint64& authenticationHashAckOut );

        /// Compute platform information on the calling platform.
        static void HK_CALL computeInformation( Info& info );

    public:

        /// The current minimum compatible protocol version.
        static const int m_protocolMinimumCompatible = hkProtocolVersion::MINIMUM;

        /// The current protocol version.
        static const int m_protocolVersion = hkProtocolVersion::CURRENT;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
