// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Log/hkLog.h>
#include <Common/Visualize/hkVisualDebuggerReporting.h>

class hkCriticalSection;
class hkVdbOStream;

/// This class facilitates sending text from the server to the vdb client.
class HK_EXPORT_COMMON hkServerTextHandler : public hkReferencedObject, public hkVisualDebuggerReporter::Output
{
public:
    HK_DECLARE_CLASS( hkServerTextHandler, New );

    /// Create a handler that writes to the provided outstream.
    hkServerTextHandler( hkVdbOStream* outStream, hkCriticalSection* outStreamLock );

    //
    // hkVisualDebuggerReporter::Output interface
    //

    
    /// Send text to the vdb client (may be deferred until flush).
    /// A tag of -1 will indicate to the client the output should be hidden by default.
    virtual hkResult outputText( hkUint64 id, hkLog::Level::Enum level, const char* text, int tag = 0 ) HK_OVERRIDE;

    /// Flush any pending output.
    virtual hkResult flush() HK_OVERRIDE;
    

protected:

    /// Lock for out stream shared with other handlers that can be called MT.
    mutable hkCriticalSection* m_outStreamLock;
    hkVdbOStream* m_outStream;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
