// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/hkServerTextHandler.h>

#include <Common/Visualize/hkVisualDebuggerCmd.h>
#include <Common/Visualize/hkVisualDebuggerCmdType.h>
#include <Common/Visualize/Serialize/hkVdbOStream.h>

#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>

hkServerTextHandler::hkServerTextHandler( hkVdbOStream* outStream, hkCriticalSection* outStreamLock ) :
    m_outStreamLock( outStreamLock ),
    m_outStream( outStream )
{}


hkResult hkServerTextHandler::outputText( hkUint64 id, hkLog::Level::Enum level, const char* text, int tag )
{
    using namespace hkVdbCmdUtils;

    bool streamOK;

    m_outStreamLock->enter();
    {
        if ( m_outStream )
        {
            const int numCharacters = ( hkString::strLen( text ) + 1 );
            const int packetSize = s8 + s64 + s8 + ( s8 * numCharacters ) + s32;
            m_outStream->write32( packetSize );

            m_outStream->write8u( hkVdbCmdType::LOG_TEXT );
            m_outStream->write64u( id );
            m_outStream->write8u( hkUint8( level ) );
            m_outStream->writeString( text );
            m_outStream->write32( tag );
        }
        streamOK = ( m_outStream && m_outStream->isOk() );
    }
    m_outStreamLock->leave();

    return  streamOK ? HK_SUCCESS : HK_FAILURE;

}

hkResult hkServerTextHandler::flush()
{
    bool streamOK;

    m_outStreamLock->enter();
    {
        if ( m_outStream )
        {
            m_outStream->getStreamWriter()->flush();
        }
        streamOK = ( m_outStream && m_outStream->isOk() );
    }
    m_outStreamLock->leave();

    return  streamOK ? HK_SUCCESS : HK_FAILURE;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
