// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Visualize/hkProcess.h>
#include <Common/Visualize/hkProcessFactory.h>
#include <Common/Visualize/hkProcessContext.h>
#include <Common/Visualize/hkCommandRouter.h>
#include <Common/Visualize/hkProcessHandler.h>
#include <Common/Visualize/hkServerDebugDisplayHandler.h>

class hkVdbIStream;
class hkVdbOStream;
class hkStreamReader;
class hkStreamWriter;
class hkServerObjectSerializer;

/// This class manages vdb client processes; implementing hkProcessHandler.
class HK_EXPORT_COMMON hkServerProcessHandler :
    public hkReferencedObject,
    public hkProcessHandler,
    public hkProcess
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VDB);

        /// Create a handler which provide the given contexts to created processes
        /// and uses the in/outstream for process-related cmds.
        hkServerProcessHandler(
            hkArray<hkProcessContext*>& contexts,
            hkStreamReader* inStream,
            hkStreamWriter* outStream);

        ~hkServerProcessHandler();

        //
        // hkProcess interface
        //

        virtual void getConsumableCommands( hkUint8*& commands, int& numCommands ) HK_OVERRIDE;
        virtual void consumeCommand( hkUint8 command ) HK_OVERRIDE;
        /// Will step all processes forward in time and will then write a step chunk (0x0) to the out stream.
        virtual void step( hkReal frameTimeInMs ) HK_OVERRIDE;
        virtual int getProcessTag() const HK_OVERRIDE { return s_tag; }

        //
        // hkProcessHandler interface
        //

        virtual hkResult registerProcess( const char* name, int tag ) HK_OVERRIDE;
        virtual int getProcessTag( const char* name ) HK_OVERRIDE { return hkProcessFactory::getInstance().getProcessTag( name ); }
        virtual const char* getProcessName( int tag ) HK_OVERRIDE { return hkProcessFactory::getInstance().getProcessName( tag ); }
        virtual hkProcess* getProcessByName( const char* name ) HK_OVERRIDE;
        virtual void getProcessesByType( int type, hkArray<hkProcess*>& processes ) HK_OVERRIDE;
        virtual hkResult selectProcess( int tag ) HK_OVERRIDE;
        virtual hkResult createProcess( int tag ) HK_OVERRIDE;
        virtual hkResult deleteProcess( int tag ) HK_OVERRIDE;

        /// Calls registerProcess for all processes in the process factory
        hkResult registerAllAvailableProcesss();

        /// Get all created processes.
        const hkArray<hkProcess*>& getProcessList() const { return m_processList; }

    protected:

        int findProcessByTag( int tag );

        /// A critical section for handlers (which could be called from different threads) to lock the outstream.
        mutable class hkCriticalSection* m_outStreamLock;

        // maps incoming data to Processes that want to service that command
        hkCommandRouter m_commandRouter;

        // owned
        hkArray<hkProcess*> m_processList;

        // not owned.
        hkArray<hkProcessContext*> m_contexts;

        // base serializer for objects
        hkRefPtr<hkServerObjectSerializer> m_serializer;

        static int s_tag;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
