// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

class hkCriticalSection;
class hkVdbOStream;

/// This class facilitates sending files from the server to the vdb client.
class HK_EXPORT_COMMON hkServerFileHandler : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS( hkServerFileHandler, New );

        /// Create a handler that writes to the provided outstream.
        hkServerFileHandler( hkVdbOStream* outStream, hkCriticalSection* outStreamLock );

        
        /// Send a file to the client.
        /// Currently, the data is written as-is to client disk, so it must be in a form that is
        /// cross-platform (such as Havok tagfiles).
        /// The file type name is intended to be a human readable understanding of the file
        /// type, such as "Havok Movie".
        /// More than one allowed extension may be provided but the first is a default hint.
        hkResult sendFileData(
            void* data,
            hkUint32 dataSize,
            const char* fileTypeName,
            hkArrayView<const char*> extensions,
            int tag = 0 );
        

    protected:

        /// Lock for out stream shared with other handlers that can be called MT.
        mutable hkCriticalSection* m_outStreamLock;
        hkVdbOStream* m_outStream;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
