// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/hkServerFileHandler.h>

#include <Common/Visualize/hkVisualDebuggerCmd.h>
#include <Common/Visualize/hkVisualDebuggerCmdType.h>
#include <Common/Visualize/Serialize/hkVdbOStream.h>

#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>

hkServerFileHandler::hkServerFileHandler( hkVdbOStream* outStream, hkCriticalSection* outStreamLock ) :
    m_outStreamLock( outStreamLock ),
    m_outStream( outStream )
{}

hkResult hkServerFileHandler::sendFileData( void* data, hkUint32 dataSize, const char* fileTypeName, hkArrayView<const char*> extensions, int tag )
{
    using namespace hkVdbCmdUtils;

    
    
    

    bool streamOK;

    m_outStreamLock->enter();
    {
        if ( m_outStream )
        {
            hkStringBuf csvExts;
            for ( hkArrayView<const char*>::iterator ext = extensions.begin();
                ext < extensions.end();
                ext++ )
            {
                csvExts.append( *ext );
                if ( ext < extensions.end() - 1 ) csvExts.append( "," );
            }

            int numCharacters = ( hkString::strLen( fileTypeName ) + 1 );
            numCharacters += ( csvExts.getLength() + 1 );
            const int packetSize = s8 + ( s8 * numCharacters ) + s32 + s32 + ( s8 * dataSize );
            m_outStream->write32( packetSize );

            m_outStream->write8u( hkVdbCmdType::SEND_FILE );
            m_outStream->writeString( fileTypeName );
            m_outStream->writeString( csvExts );
            m_outStream->write32( tag );
            // Write data last so that dialogs can be presented to user, etc. even as data is being read in (if implementation so choses)
            m_outStream->write32u( dataSize );
            m_outStream->writeRaw( data, dataSize );
        }
        streamOK = ( m_outStream && m_outStream->isOk() );
    }
    m_outStreamLock->leave();

    return  streamOK ? HK_SUCCESS : HK_FAILURE;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
