// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Visualize/hkDebugDisplayHandler.h>
#include <Common/Visualize/hkProcess.h>
#include <Common/Base/Container/Set/hkSet.h>

class hkVdbOStream;
class hkVdbIStream;
class hkCriticalSection;
class DeprecatedDebugDisplayHandlerImpl;

/// This class facilitates sending debug display data from the server to the vdb client.
class HK_EXPORT_COMMON hkServerDebugDisplayHandler : public hkDebugDisplayHandler, public hkProcess
{
    public:
        HK_DECLARE_CLASS(hkServerDebugDisplayHandler, New);

        /// Create a handler that writes to the provided outstream
        /// and reads cmds from the instream.
        hkServerDebugDisplayHandler(
            hkVdbOStream* outStream,
            hkCriticalSection* outStreamLock,
            hkVdbIStream* inStream = HK_NULL );
        ~hkServerDebugDisplayHandler();

        //
        // hkDebugDisplayHandler interface
        //

        virtual hkResult setDisplayOptions( Options& options ) HK_OVERRIDE;
        virtual hkResult addGeometry(
            hkUint64 id,
            const hkArrayBase<hkDisplayGeometry*>& geometries,
            const hkTransform& transform,
            int tag = 0 ) HK_OVERRIDE;
        using hkDebugDisplayHandler::addGeometry;
        virtual hkResult addGeometryEx(
            hkUint64 id,
            const hkArrayBase<hkDisplayGeometry*>& geometries,
            const hkTransform& transform,
            const hkColor::Argb color,
            hkDisplayGeometryFlags flags = hkDisplayGeometryFlags::DEFAULT,
            int tag = 0 ) HK_OVERRIDE;
        using hkDebugDisplayHandler::addGeometryEx;
        virtual hkResult addGeometryInstance(
            hkUint64 id,
            hkUint64 originalGeomId,
            const hkTransform& transform,
            int tag = 0 ) HK_OVERRIDE;
        virtual hkResult setGeometryFlagBits( hkUint64 id, hkDisplayGeometryFlags flagBits ) HK_OVERRIDE;
        virtual hkResult clearGeometryFlagBits( hkUint64 id, hkDisplayGeometryFlags flagBits ) HK_OVERRIDE;
        virtual hkResult setGeometryColor( hkUint64 id, hkColor::Argb color ) HK_OVERRIDE;
        virtual hkResult setGeometryAlpha( hkUint64 id, hkReal alpha ) HK_OVERRIDE;
        virtual hkResult updateGeometryTransform( hkUint64 id, const hkTransform& transform ) HK_OVERRIDE;
        virtual hkResult updateGeometryTransformEx( hkUint64 id, const hkMatrix4& transform ) HK_OVERRIDE;
        using hkDebugDisplayHandler::updateGeometryTransformEx;
        virtual hkResult updateParticleTransforms( hkUint64 id, int updateId, const hkQuaternion* orientations, const hkVector4* translations, hkUint32 numTransforms ) HK_OVERRIDE;
        virtual hkResult updateGeometryVerts( hkUint64 id, const hkArray<hkVector4>& newVerts ) HK_OVERRIDE;
        virtual hkResult removeGeometry( hkUint64 id ) HK_OVERRIDE;
        virtual hkResult updateCamera(
            const char* name,
            hkVector4Parameter from,
            hkVector4Parameter to,
            hkVector4Parameter up,
            hkReal nearPlane,
            hkReal farPlane,
            hkReal fov ) HK_OVERRIDE;
        virtual hkResult removeCamera( const char* name ) HK_OVERRIDE;
        virtual hkResult displayPoint( hkUint64 id, hkVector4Parameter a, hkColor::Argb color, int tag = 0 ) HK_OVERRIDE;
        virtual hkResult displayPointEx( hkUint64 id, hkVector4Parameter a, hkColor::Argb color, hk1PointDisplayStyle::Enum style = hk1PointDisplayStyle::DOT, hkReal scale = 0, int tag = 0 ) HK_OVERRIDE;
        virtual hkResult display2Points( hkUint64 id, hkVector4Parameter a, hkVector4Parameter b, hkColor::Argb color, int tag = 0 ) HK_OVERRIDE;
        virtual hkResult display2PointsEx( hkUint64 id, hkVector4Parameter a, hkVector4Parameter b, hkColor::Argb color, hk2PointDisplayStyle::Enum style = hk2PointDisplayStyle::LINE_SEGMENT, hkReal thickness = 0, int tag = 0 ) HK_OVERRIDE;
        virtual hkResult display3Points( hkUint64 id, hkVector4Parameter a, hkVector4Parameter b, hkVector4Parameter c, hkColor::Argb color, int tag = 0 ) HK_OVERRIDE;
        
        virtual hkResult displayText( hkUint64 id, const char* text, hkColor::Argb color, int tag = 0 ) HK_OVERRIDE;
        virtual hkResult display3dText( hkUint64 id, const char* text, hkVector4Parameter pos, hkColor::Argb color, int tag = 0 ) HK_OVERRIDE;
        virtual hkResult displayGeometry( hkUint64 id, const hkArrayBase<hkDisplayGeometry*>& geometries, const hkTransform& transform, hkColor::Argb color, int tag = 0 ) HK_OVERRIDE;
        using hkDebugDisplayHandler::displayGeometry;
        virtual hkResult flushDisplay( bool clearDisplayGeometry = true ) HK_OVERRIDE;          /// Flush the out stream
        virtual hkDeprecatedDebugDisplayHandlerInterface* getDeprecatedInterface() HK_OVERRIDE;
        hkResult flushStream();

        //
        // hkProcess interface
        // (used for deprecated hashing geometry support)
        //

        virtual void getConsumableCommands( hkUint8*& commands, int& numCommands ) HK_OVERRIDE;
        virtual void consumeCommand( hkUint8 command ) HK_OVERRIDE;
        virtual int getProcessTag() const HK_OVERRIDE { return -1; }
        virtual void step( hkReal frameTimeInMs ) HK_OVERRIDE;

    protected:

        /// Lock for out stream shared with other handlers that can be called MT.
        mutable hkCriticalSection* m_outStreamLock;
        hkRefPtr<DeprecatedDebugDisplayHandlerImpl> m_deprecatedHandler;
        typedef hkSet<hkUint64> GeometryIdSet;
        HK_DEBUG_ONLY_MEMBER( GeometryIdSet, m_addedGeometries );
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
