// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/hkProcessSerializeUtils.h>

#include <Common/Base/Serialize/hkSerialize.h>
#include <Common/Base/Serialize/Format/Tagfile/hkTagfileWriteFormat.h>
#include <Common/Base/Serialize/Format/Tagfile/hkTagfileReadFormat.h>

#include <Common/Base/Reflect/Util/hkReflectClone.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/Serialize/Detail/hkSerializeDetail.h>

hkResult HK_CALL hkProcessSerializeUtils::varToBuffer(hkRefPtr<hkSerialize::WriteFormat>& format, const hkReflect::Var& var, hkArray<char>& buf )
{
    if (!format)
    {
        format.setAndDontIncrementRefCount(new hkSerialize::TagfileWriteFormat() );
        HK_ON_DEBUG( hkResult result = ) format->enableMultiBundle();
        HK_ASSERT_NO_MSG( 0x46af053c, result.isSuccess() );
    }

    hkIo::WriteBuffer writeBuffer(&buf);
    hkSerialize::BundleBuilder bb(format, &writeBuffer);
    bb.add(var);
    bb.recursiveAdd();

    return HK_SUCCESS;
}

hkResult HK_CALL hkProcessSerializeUtils::bufferToVar( hkRefPtr<hkSerialize::ReadFormat>& format, hkArrayView<char> buf, hkReflect::Var& var )
{
    if (!format)
    {
        format.setAndDontIncrementRefCount(new hkSerialize::TagfileReadFormat() );
    }

    hkUlong used = 0;
    if (hkViewPtr<hkSerialize::Bundle> bundle = format->view(buf.begin(), buf.getSize(), &used))
    {
        //HK_ASSERT_NO_MSG(0x46af053b, used==hkUlong(buf.getSize()));
        hkSerialize::Detail::CloneToRegistered callback;

        var = hkReflect::Cloner().cloneVar(bundle->getContents(), callback);

        if(var)
        {
            
            if(const hkReferencedObject* ro = hkDynCast<hkReferencedObject>(var))
            {
                // Serialization will have created this with a 0 RC
                // We need it at 1 to manage the ownership correctly
                ro->addReference();
            }
            return HK_SUCCESS;
        }
    }
    return HK_FAILURE;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
