// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkProcess;

/// This class defines the interface to control the state of processes (viewers)
/// in the visual debugger.
class HK_EXPORT_COMMON hkProcessHandler
{
    //+hk.MemoryTracker(ignore=True)
public:
    virtual ~hkProcessHandler() {}

    /// Registers a process for creation, selection, deletion.
    virtual hkResult registerProcess( _In_z_ const char* name, int id ) = 0;

    /// Query for the tag of a named process type.
    virtual int getProcessTag( _In_z_ const char* name ) = 0;

    /// Query for the name of a given tag.
    virtual _Ret_z_ const char* getProcessName( int tag ) = 0;

    /// Find a created process that has the given name.
    virtual _Ret_ hkProcess* getProcessByName( _In_z_ const char* name ) = 0;

    /// Find created processes of the given ProcessType.
    virtual void getProcessesByType( int type, hkArray<hkProcess*>& processes ) = 0;

    /// Inform the visual debugger that a process should be selected.
    /// The visual debugger can respond by creating the process (createProcess).
    virtual hkResult selectProcess( int id ) = 0;

    /// Creates an instance of the process identified by id.
    /// The process is only created if one does not already exist.
    virtual hkResult createProcess( int id ) = 0;

    /// Deletes a process identified by id.
    virtual hkResult deleteProcess( int id ) = 0;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
