// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkProcessScheduler;
class hkProcessContext;

/// This class stores a list of processes that can be created.
/// This is a thread safe singleton
class HK_EXPORT_COMMON hkProcessFactory : public hkReferencedObject
{
        friend class hkProcessHandler;
        friend class hkServerProcessHandler;

    public:

        HK_DECLARE_CLASS(hkProcessFactory, New, Singleton);

        typedef _Ret_maybenull_ class hkProcess* (HK_CALL *hkProcessCreationFunction)( const hkArray<hkProcessContext*>& contexts );

        hkProcessFactory();
        ~hkProcessFactory();

            /// Registers a process with hkProcessFactory instance.
            /// Returns a tag which should be used by the process to identify the data it produces.
        int registerProcess(
            _In_z_ const char* viewerName,
            hkProcessCreationFunction creationFunction);

            /// Get a registered process name by tag.
        _Ret_z_ const char* getProcessName(int tag);
        
            /// Get a registered process tab by name.
        int getProcessTag(_In_z_ const char* name);

            /// Creates a process identified by 'processName'. Caller owns it.
            /// Be careful if you call this (normally a handler would call them and setup the processes)
        _Ret_maybenull_ hkProcess* createProcess(_In_z_ const char *processName, hkArray<hkProcessContext*>& contexts);
        _Ret_maybenull_ hkProcess* createProcess(int tag, hkArray<hkProcessContext*>& contexts);

            /// Clear the list of registered processes. Do not call this while the VDB is connected
        void clearProcesses();

    public:

            /// Information about a registered process
        struct HK_EXPORT_COMMON ProcessTagPair
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_ARRAY, ProcessTagPair);
            hkStringPtr m_name;
            hkProcessCreationFunction m_processCreationFunction;
            int m_tag;
        };
        const hkArray<ProcessTagPair>& getName2CreationFunction() const { return m_name2creationFunction; }

    protected:

        int m_freeTag; // tag generator, starts at 0 and increments

        hkArray<ProcessTagPair> m_name2creationFunction;

        mutable class hkCriticalSection* m_criticalSection;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
