// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/hkProcess.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>
#include <Common/Visualize/hkProcessFactory.h>
#include <Common/Base/Object/hkSingleton.h>

hkProcessFactory::hkProcessFactory()
: m_freeTag(0)
{
    m_criticalSection = new hkCriticalSection(2000);
}

hkProcessFactory::~hkProcessFactory()
{
    delete m_criticalSection;
}

int hkProcessFactory::registerProcess(_In_z_ const char* viewerName, hkProcessCreationFunction creationFunction)
{
    ProcessTagPair* pair = HK_NULL;

    m_criticalSection->enter();

    // check viewer is not already registered
    for(int i = 0; i < m_name2creationFunction.getSize(); i++)
    {
        if( m_name2creationFunction[i].m_name == viewerName )
        {
            pair = &m_name2creationFunction[i];

            if ( m_name2creationFunction[i].m_processCreationFunction != creationFunction )
            {
                HK_ASSERT(0x7ce319a1,  0, "You are trying to register two different process with the same name - only the first instance will be used" );
            }
            break;
        }
    }

    if( pair == HK_NULL )
    {
        pair = m_name2creationFunction.expandBy(1);
        pair->m_name = viewerName;
        pair->m_processCreationFunction = creationFunction;
        pair->m_tag = m_freeTag++;
    }

    m_criticalSection->leave();

    return pair->m_tag;
}

_Ret_z_ const char* hkProcessFactory::getProcessName(int tag)
{
    m_criticalSection->enter();
    const char* name = m_name2creationFunction[tag].m_name.cString();
    m_criticalSection->leave();
    return name;
}

int hkProcessFactory::getProcessTag(_In_z_ const char* name)
{
    m_criticalSection->enter();
    for(int i = 0; i < m_name2creationFunction.getSize(); i++)
    {
        const hkStringPtr& pname = m_name2creationFunction[i].m_name;
        if( pname == name )
        {
            m_criticalSection->leave();
            return i;
        }
    }
    m_criticalSection->leave();
    return -1;
}

_Ret_maybenull_ hkProcess* hkProcessFactory::createProcess(int tag, hkArray<hkProcessContext*>& contexts)
{
    hkCriticalSectionLock lock( m_criticalSection );

    HK_ASSERT(0x7ce319a2, (tag >=0) && (tag < m_freeTag) &&
        (tag < m_name2creationFunction.getSize()), "VDB: Process tag out of range");

    hkProcess* p = m_name2creationFunction[tag].m_processCreationFunction(contexts);

    return p;
}

_Ret_maybenull_ hkProcess* hkProcessFactory::createProcess(_In_z_ const char* processName, hkArray<hkProcessContext*>& contexts)
{
    hkCriticalSectionLock lock( m_criticalSection );
    int tag = getProcessTag(processName);
    return tag < 0? HK_NULL : createProcess(tag, contexts);
}

void hkProcessFactory::clearProcesses()
{
    hkCriticalSectionLock lock(m_criticalSection);
    m_name2creationFunction.clear();
    m_freeTag = 0;
}

HK_SINGLETON_IMPLEMENTATION(hkProcessFactory);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
