// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/hkSignalSlots.h>

// Workaround warning C4370
class HK_EXPORT_COMMON hkProcessContextBase
{
    public:
        virtual ~hkProcessContextBase() {}
};

/// Provides a way to get information to Visual Debugger processes (e.g. viewers) in a generic way.
class HK_EXPORT_COMMON hkProcessContext : public hkProcessContextBase
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,hkProcessContext);

        hkProcessContext() {}

        virtual ~hkProcessContext();

            /// Get the type of context. Common ones are 'Physics' or 'Animation'.
            /// Leave it open as a generic string so that users can make their own contexts for Processes.
        _Ret_z_ virtual const char* getType() = 0;

    public:

        HK_DECLARE_SIGNAL( ContextDestroyedSignal, hkSignal1<hkProcessContext*> );

            /// Signal fired before the context is destroyed.
        ContextDestroyedSignal m_contextDestroyedSignal;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
