// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkVdbIStream;
class hkVdbOStream;
class hkDebugDisplayHandler;
class hkServerObjectHandler;
class hkServerFileHandler;
class hkServerTextHandler;
class hkProcessHandler;

/// A process (viewer) used by the visual debugger
class HK_EXPORT_COMMON hkProcess
{
public:

    /// A type used to identify a process (no longer used).
    enum ProcessType
    {
        HK_PROCESS_TYPE_UNKNOWN = -1,
        HK_PROCESS_TYPE_BEHAVIOR = 1,
    };

public:
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE, hkProcess );
    hkProcess() : m_processHandler( HK_NULL ) {}
    virtual ~hkProcess() {}

    /// Gets type identification for the viewer (no longer used).
    virtual ProcessType getType() const { return HK_PROCESS_TYPE_UNKNOWN; }

    
    /// Get the unique tag for this process (provided by hkProcessFactory).
    virtual int getProcessTag() const = 0;

    /// Get the commands this process understands so
    /// that this process can be mapped correctly and get
    /// called when appropriate.
    virtual void getConsumableCommands(
        _Outref_result_bytebuffer_maybenull_( numCommands ) hkUint8*& commands,
        _Out_ int& numCommands )
    { commands = HK_NULL; numCommands = 0; }

    /// Given an input stream and a command type (that has already been parsed from
    /// the stream), consume the data.
    virtual void consumeCommand( hkUint8 cmdType ) { }

    /// Returns true if the process is okay.
    /// Default implementation checks the out streams status.
    virtual bool isOk();

    /// Called after the process is created and it's streams/handlers are set.
    virtual void init() { }

    /// Step the process.
    /// This is called once per visual debugger step.
    virtual void step( hkReal frameTimeInMs ) { }
    

    /// Returns true if the process is a local process in the demo framework, false otherwise.
    bool isLocalViewer() const { return m_outStream == HK_NULL && m_inStream == HK_NULL; }

public:

    // The streams and interfaces the process can use to communicate
    hkRefPtr<hkVdbIStream> m_inStream;
    hkRefPtr<hkVdbOStream> m_outStream;
    hkRefPtr<hkDebugDisplayHandler> m_displayHandler;
    hkRefPtr<hkServerObjectHandler> m_objectHandler;
    hkRefPtr<hkServerFileHandler> m_fileHandler;
    hkRefPtr<hkServerTextHandler> m_textHandler;
    hkProcessHandler* m_processHandler;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
