// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Visualize/hkProcessContext.h>
#include <Common/Base/Monitor/hkMonitorStream.h>

class hkThreadPool;

#define HK_COMMON_PROCESS_CONTEXT_TYPE_STRING "Common"

class hkCommonProcessContext : public hkReferencedObject, public hkProcessContext
{
public:
    HK_DECLARE_CLASS(hkCommonProcessContext, New);

    virtual const char* getType() override { return HK_COMMON_PROCESS_CONTEXT_TYPE_STRING; }

    /// Synchronize the local monitor stream pointers with the current state of the monitor stream
    /// of this thread plus those of any other threads in the given thread pool.
    HK_EXPORT_COMMON void syncTimers(_Inout_opt_ hkThreadPool* threadPool = HK_NULL);

public:
    /// Used by the statistics process, the current start and end of the threads being timed.
    /// If they are empty arrays, will use the static hkMonitorStream::begin() and
    /// hkMonitorStream::end() pointers directly instead.
    hkInplaceArray<hkTimerData, 32> m_monitorStreams;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
