// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/PointerMultiMap/hkPointerMultiMap.h>
class hkVdbIStream;
class hkProcess;

/// A class to deserialize chunks of data that have come from the vdb client to the server.
/// For example the creation and deletion of viewers.
class HK_EXPORT_COMMON hkCommandRouter : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VDB);

            /// Register process so it can consume client cmds.
            /// Handlers are not reference counted so they should persist as long as
            /// this hkCommandRouter exists, or be unregistered.
        void registerProcess(_Inout_ hkProcess* handler);
        void unregisterProcess(_Inout_ hkProcess* handler);

            /// Consume the commands until an STEP_ACK is reached or the stream is not OK anymore
        hkBool consumeCommands(_Inout_ hkVdbIStream* stream);

    protected:

            /// Commands to processes that understand them.
        hkPointerMultiMap< hkUint8, hkProcess* > m_commandMap;

            /// Whether we have received version information from the client or not.
        bool m_haveClientVersion;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
