// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Math/Util/hkPack.h>
#include <Common/Base/Container/FreeListArray/hkFreeListArray.h>

struct TestSimpleRecord
{
    HK_DECLARE_CLASS( TestSimpleRecord, New, Reflect );
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    TestSimpleRecord( bool val = true ) :
        m_bool( val ),
        m_int( val ),
        m_real( val ),
        m_bits( 1, val ? hkBitFieldValue::ONE : hkBitFieldValue::ZERO )
    {
        m_flArray.allocate( val );
    }
    bool m_bool;
    int m_int;
    hkReal m_real;
    hkBitField m_bits;
    hkFreeListArray<int, bool, 2> m_flArray;
};

struct TestSimpleExRecord : public TestSimpleRecord
{
    HK_DECLARE_CLASS( TestSimpleExRecord, New, Reflect );
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    TestSimpleExRecord( bool val = true ) :
        TestSimpleRecord( val ),
        m_boolEx( val ),
        m_intEx( val ),
        m_realEx( val ),
        m_bitsEx( 64, val ? hkBitFieldValue::ONE : hkBitFieldValue::ZERO )
    {
        m_flArrayEx.allocate( val );
    }
    hkBool m_boolEx;
    hkUint8 m_intEx;
    hkDouble64 m_realEx;
    hkBitField m_bitsEx;
    hkFreeListArray<int, bool, 2> m_flArrayEx;
};

struct TestSimpleContainerRecord
{
    HK_DECLARE_CLASS( TestSimpleContainerRecord, New, Reflect );
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    TestSimpleContainerRecord( bool val = true )
    {
        for ( int i = 0; i < HK_COUNT_OF( m_fixedValueOne ); i++ )
        {
            m_fixedValueOne[i] = val;
        }
        for ( int i = 0; i < HK_COUNT_OF( m_fixedValueMany ); i++ )
        {
            m_fixedValueMany[i] = val;
        }
        for ( int i = 0; i < HK_COUNT_OF( m_fixedSimpleRecordOne ); i++ )
        {
            m_fixedSimpleRecordOne[i].~TestSimpleRecord();
            new ( &m_fixedSimpleRecordOne[i] ) TestSimpleRecord( val );
        }
        for ( int i = 0; i < HK_COUNT_OF( m_fixedSimpleRecordMany ); i++ )
        {
            m_fixedSimpleRecordMany[i].~TestSimpleRecord();
            new ( &m_fixedSimpleRecordMany[i] ) TestSimpleRecord( val );
        }
        for ( int i = 0; i < HK_COUNT_OF( m_fixedSimpleExRecordOne ); i++ )
        {
            m_fixedSimpleExRecordOne[i].~TestSimpleExRecord();
            new ( &m_fixedSimpleExRecordOne[i] ) TestSimpleExRecord( val );
        }
        for ( int i = 0; i < HK_COUNT_OF( m_fixedSimpleExRecordMany ); i++ )
        {
            m_fixedSimpleExRecordMany[i].~TestSimpleExRecord();
            new ( &m_fixedSimpleExRecordMany[i] ) TestSimpleExRecord( val );
        }
    }
    bool m_fixedValueOne[1];
    int m_fixedValueMany[10];
    TestSimpleRecord m_fixedSimpleRecordOne[1];
    TestSimpleRecord m_fixedSimpleRecordMany[10];
    TestSimpleExRecord m_fixedSimpleExRecordOne[1];
    TestSimpleExRecord m_fixedSimpleExRecordMany[10];
};

struct TestComplexRecord
{
    HK_DECLARE_CLASS( TestComplexRecord, New, Reflect );
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    TestComplexRecord( bool val = true ) :
        //m_bools( 10, val ),
        //m_ints( 10, val ),
        //m_reals( 10, val ),
        m_cstring( val ? "1" : "0" ),
        m_string( val ? "1" : "0" )
    {}
    //hkArray<bool> m_bools;
    //hkArray<int> m_ints;
    //hkArray<hkReal> m_reals;
    const char* m_cstring;
    hkStringPtr m_string;
};

struct TestComplexContainerRecord
{
    HK_DECLARE_CLASS( TestComplexContainerRecord, New, Reflect );
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    TestComplexContainerRecord( bool val = true )
    {
        for ( int i = 0; i < HK_COUNT_OF( m_fixedRecordOne ); i++ ) m_fixedRecordOne[i] = val ? "1" : "0";
        for ( int i = 0; i < HK_COUNT_OF( m_fixedValueMany ); i++ ) m_fixedValueMany[i] = val ? "1" : "0";
        for ( int i = 0; i < HK_COUNT_OF( m_fixedRecordOne ); i++ ) new ( &m_fixedRecordOne[i] ) TestComplexRecord( val );
        for ( int i = 0; i < HK_COUNT_OF( m_fixedRecordMany ); i++ ) new ( &m_fixedRecordMany[i] ) TestComplexRecord( val );
    }
    const char* m_fixedValueOne[1];
    hkStringPtr m_fixedValueMany[10];
    TestComplexRecord m_fixedRecordOne[1];
    TestComplexRecord m_fixedRecordMany[10];
};

struct TestInvalidRecord
{
    HK_DECLARE_CLASS( TestInvalidRecord, New, Reflect );
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    TestInvalidRecord( bool val = true )
    {}
    hkRefPtr<hkReferencedObject> m_refObject;
};

struct SerializeVdbObjectExtraFails
{
    enum Enum
    {
        NONE = 0,

        // Test will fail if any sub-type (in a record, array, etc.) is unsupported
        // and therefore skipped when inspecting properties on client.
        UNSUPPORTED_SUB_TYPES = ( 1 << 0 ),
        // Test will fail if the type contains no supported fields.
        EMPTY_TYPE = ( 1 << 1 ),

        ALL = ( UNSUPPORTED_SUB_TYPES | EMPTY_TYPE )
    };
};

struct SerializeVdbObjectStats
{
    SerializeVdbObjectStats( const char* name = "Serialize Vdb Object Stats" ) :
        m_name( name )
        , m_serializeType( 0 )
        , m_deserializeType( 0 )
        , m_destroyType( 0 )
        , m_computeObjectSize( 0 )
        , m_serializeObject( 0 )
        , m_deserializeObject( 0 )
        , m_destroyObject( 0 )
    {}

    hkStringPtr m_name;
    hkReal m_serializeType;
    hkReal m_deserializeType;
    hkReal m_destroyType;
    hkReal m_computeObjectSize;
    hkReal m_serializeObject;
    hkReal m_deserializeObject;
    hkReal m_destroyObject;

    HK_INLINE void printTo( hkStringBuf& buf, bool csv = true )
    {
        if ( csv )
        {
            buf.appendPrintf(
                "%s,"
                "%g,"
                "%g,"
                "%g,"
                "%g,"
                "%g,"
                "%g\n"
                , m_name.cString()
                , m_serializeType
                , m_deserializeType
                , m_destroyType
                , m_computeObjectSize + m_serializeObject
                , m_deserializeObject
                , m_destroyObject );
        }
        else
        {
            buf.appendPrintf(
                "%s:\n"
                "\tSerialize Type: %g\n"
                "\tDeserialize Type: %g\n"
                "\tDestroy Type: %g\n"
                "\tCompute Object Size: %g\n"
                "\tSerialize Object: %g\n"
                "\tSerialize Object Total: %g\n"
                "\tDeserialize Object: %g\n"
                "\tDestroy Object: %g\n"
                , m_name.cString()
                , m_serializeType
                , m_deserializeType
                , m_destroyType
                , m_computeObjectSize
                , m_serializeObject
                , m_computeObjectSize + m_serializeObject
                , m_deserializeObject
                , m_destroyObject );
        }
    }
};

class hkStreamWriter;
class hkStreamReader;
namespace hkVdbSerialize { class TypeSave; }
namespace hkVdbSerialize { class TypeLoad; }
HK_EXPORT_COMMON hkReal Serialize_vdbObject(
    hkReflect::Var var,
    hkVdbSerialize::TypeSave& typeSaver,
    hkVdbSerialize::TypeLoad& typeLoader,
    SerializeVdbObjectExtraFails::Enum failOn = SerializeVdbObjectExtraFails::NONE,
    SerializeVdbObjectStats* statsOut = HK_NULL,
    int num = 1 );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
