// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Visualize/Shape/hkDisplayGeometry.h>

class HK_EXPORT_COMMON hkDisplayTaperedCapsule : public hkDisplayGeometry
{
    public:

        HK_DECLARE_CLASS( hkDisplayTaperedCapsule, New );

        hkDisplayTaperedCapsule( const hkVector4& top, const hkVector4& bottom, hkReal topRadius, hkReal bottomRadius,
                                 int numSides = 6, int numHeightSegments = 3 );

        virtual void buildGeometry() const HK_OVERRIDE;

        virtual void getWireframeGeometry(hkArrayBase<hkVector4>& lines, hkMemoryAllocator& alloc) const HK_OVERRIDE;

        const hkVector4& getTop() const { return m_top; }
        const hkVector4& getBottom() const { return m_bottom; }
        hkReal getTopRadius() const { return m_topRadius; }
        hkReal getBottomRadius() const { return m_bottomRadius; }

        inline int getNumHeightSamples() const { return m_numHeightSegments; }
        inline int getNumSides() const { return m_numSides; }

    protected:

        hkVector4   m_top;
        hkVector4   m_bottom;
        hkReal      m_topRadius;
        hkReal      m_bottomRadius;

        int m_numSides;
        int m_numHeightSegments;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
