// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Visualize/hkVisualize.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>
#include <Common/GeometryUtilities/Misc/hkGeometryUtils.h>
#include <Common/Visualize/Shape/hkDisplayTaperedCapsule.h>

hkDisplayTaperedCapsule::hkDisplayTaperedCapsule( const hkVector4& top, const hkVector4& bottom, hkReal topRadius, hkReal bottomRadius, int numSides , int numHeightSegments )
:  hkDisplayGeometry(HK_DISPLAY_TAPERED_CAPSULE),
   m_numSides(numSides), m_numHeightSegments(numHeightSegments)
{
    m_top = top;
    m_bottom = bottom;
    m_topRadius = topRadius;
    m_bottomRadius = bottomRadius;
}

void hkDisplayTaperedCapsule::buildGeometry() const
{
    m_geometry = new hkGeometry();
    hkGeometryUtils::appendTaperedCapsule(m_top, m_bottom, m_topRadius, m_bottomRadius, m_numHeightSegments, m_numSides, hkTransform::getIdentity(), *m_geometry);
}

void hkDisplayTaperedCapsule::getWireframeGeometry(hkArrayBase<hkVector4>& lines, hkMemoryAllocator& alloc) const
{
    
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
