// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Visualize/hkVisualize.h> //PCH
#include <Common/Visualize/Shape/hkDisplaySphere.h>
#include <Common/GeometryUtilities/Misc/hkGeometryUtils.h>

hkDisplaySphere::hkDisplaySphere(const hkSphere& sphere, int subdivisions)
:  hkDisplayGeometry(HK_DISPLAY_SPHERE),
    m_sphere(sphere),
    m_subdivisions(subdivisions)
{
    m_transform.set( hkQuaternion::getIdentity(), hkVector4::getZero() );
}

void hkDisplaySphere::buildGeometry() const
{
    m_geometry = new hkGeometry;
    hkGeometryUtils::appendSphere( m_sphere.getPosition(), m_sphere.getRadius(), m_subdivisions, *m_geometry );
}

void hkDisplaySphere::getWireframeGeometry( hkArrayBase<hkVector4>& lines, hkMemoryAllocator& a ) const
{
    hkGeometry tempGeom;
    hkGeometryUtils::appendSphere(m_sphere.getPosition(), m_sphere.getRadius(), m_subdivisions, tempGeom );

    lines._reserve( a, lines.getSize() + tempGeom.m_triangles.getSize() * 3 );
    for( int t = 0; t < tempGeom.m_triangles.getSize(); t++ )
    {
        int* triVerts = &tempGeom.m_triangles[t].m_a;
        for (int i = 0; i < 3; ++i)
        {
            int j = (i+1)%3;
            if (triVerts[i] < triVerts[j])
            {
                lines._pushBack(a, tempGeom.m_vertices[triVerts[i]]);
                lines._pushBack(a, tempGeom.m_vertices[triVerts[j]]);
            }
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
