// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Visualize/Shape/hkDisplayGeometry.h>

class HK_EXPORT_COMMON hkDisplaySemiCircle : public hkDisplayGeometry
{
    public:
        HK_DECLARE_CLASS( hkDisplaySemiCircle, New );

        hkDisplaySemiCircle(const hkVector4& center,
                            const hkVector4& normal,
                            const hkVector4& startPerp,
                            const hkReal thetaMin,
                            const hkReal thetaMax,
                            const hkReal radius,
                            const int numSegments);

        hkDisplaySemiCircle();

        virtual void buildGeometry() const HK_OVERRIDE;

        virtual void getWireframeGeometry( hkArrayBase<hkVector4>& lines, hkMemoryAllocator& a ) const HK_OVERRIDE;

        void setParameters(const hkReal radius,
                           const hkReal thetaMin,
                           const hkReal thetaMax,
                           const int numSegments,
                           const hkVector4& center,
                           const hkVector4& normal,
                           const hkVector4& startPerp);

        // get normal to plane containing semi-circle
        hkVector4 getNormal() const;

        // get center of semi-circle in WS
        hkVector4 getCenter() const;

        // get perp to normal in WS
        hkVector4 getPerp() const;

        // get min angular extent
        hkReal getThetaMin() const;

        // get max angular extent
        hkReal getThetaMax() const;

        // get radius
        hkReal getRadius() const;

        int getNumSegments() const;

    protected:

        hkVector4 m_normal;

        hkVector4 m_perp;

        hkVector4 m_center;

        hkReal m_thetaMin;

        hkReal m_thetaMax;

        hkReal m_radius;

        int m_numSegments;

        void generatePoints(hkArray<hkVector4>& points) const;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
