// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Visualize/Shape/hkDisplayGeometry.h>

class HK_EXPORT_COMMON hkDisplayPlane : public hkDisplayGeometry
{
    public:

        HK_DECLARE_CLASS( hkDisplayPlane, New );

        hkDisplayPlane();
        hkDisplayPlane(const hkVector4& normal, const hkVector4& perpToNormal,
            const hkVector4& center, const hkVector4& extents);


        virtual void buildGeometry() const HK_OVERRIDE;

        virtual void getWireframeGeometry( hkArrayBase<hkVector4>& lines, hkMemoryAllocator& a ) const HK_OVERRIDE;

        void setParameters(const hkVector4& normal, const hkVector4& perpToNormal,
                           const hkVector4& center,  const hkVector4& extents);

        hkVector4& getNormal();

        hkVector4& getCenter();

        hkVector4& getPerpToNormal();

        hkVector4& getExtents();

    protected:

        hkVector4 m_normal;
        hkVector4 m_center;
        hkVector4 m_perpToNormal;
        hkVector4 m_extent;

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
