// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Visualize/Shape/hkDisplayGeometry.h>
#include <Common/GeometryUtilities/Mesh/hkMeshBody.h>

    /// Display geometry that contains a generic mesh body.
class HK_EXPORT_COMMON hkDisplayMesh : public hkDisplayGeometry
{
    public:

        HK_DECLARE_CLASS( hkDisplayMesh, New );

            /// Initializes the display mesh with a mesh
        hkDisplayMesh(_In_ hkMeshBody* mesh);

            /// Gets the mesh body which the display mesh wraps
        _Ret_notnull_ hkMeshBody* getMesh() const;

            /// hkDisplayGeometry interface. Does nothing.
        virtual void buildGeometry() const HK_OVERRIDE;
            /// hkDisplayGeometry interface. Does nothing.
        virtual void getWireframeGeometry( hkArrayBase<hkVector4>& lines, hkMemoryAllocator& a ) const HK_OVERRIDE;

            /// Serializes the mesh to an internally stored buffer.
        void serializeMeshData();
            /// Frees any serialized mesh data.
        void freeSerializedMeshData();

            /// Gets the size of the buffer that holds the serialized mesh data. serializeMeshData must
            /// be called before this method.
        int getSeriaizedMeshDataSize() const;
            /// Gets the buffer that holds the serialized mesh data. serializeMeshData must
            /// be called before this method.
        _Ret_notnull_ const char* getSeriaizedMeshData() const;

    protected:

            /// The mesh which the display mesh wraps.
        hkRefPtr<hkMeshBody> m_mesh;
            /// The mesh serialized to a buffer. This is used in conjunction with the
            /// hkServerDebugDisplayHandler and is needed because the handler does not
            /// buffer the display data before sending it.
        hkArray<char> m_meshAsTagfile;

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
