// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/Shape/hkDisplayMesh.h>
#include <Common/GeometryUtilities/Mesh/hkMeshBody.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>
#include <Common/Base/Math/Matrix/hkMatrixDecomposition.h>

hkDisplayMesh::hkDisplayMesh(_In_ hkMeshBody* mesh)
:hkDisplayGeometry(HK_DISPLAY_MESH),
m_mesh(mesh)
{
    hkMatrix4 matrix;
    mesh->getTransform(matrix);

    hkMatrixDecomposition::Decomposition decomp;
    hkMatrixDecomposition::decomposeMatrix(matrix, decomp);

    hkTransform transform; transform.set(decomp.m_rotation, decomp.m_translation);
    setTransform(transform);
}

_Ret_notnull_ hkMeshBody* hkDisplayMesh::getMesh() const
{
    return m_mesh;
}

void hkDisplayMesh::buildGeometry() const
{
}

void hkDisplayMesh::getWireframeGeometry( hkArrayBase<hkVector4>& lines, hkMemoryAllocator& a ) const
{
}

void hkDisplayMesh::serializeMeshData()
{
    m_meshAsTagfile.clear();
    hkOstream buffer(m_meshAsTagfile);

    hkSerializeUtil::save(m_mesh.val(), buffer.getStreamWriter());
}

void hkDisplayMesh::freeSerializedMeshData()
{
    m_meshAsTagfile.clearAndDeallocate();
}

int hkDisplayMesh::getSeriaizedMeshDataSize() const
{
    return m_meshAsTagfile.getSize();
}

_Ret_notnull_ const char* hkDisplayMesh::getSeriaizedMeshData() const
{
    return m_meshAsTagfile.begin();
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
