// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

struct HK_EXPORT_COMMON hkDisplayGeometryFlags : public hkFlagsEx<hkUint8>
{
    enum Bits
    {
        NONE = 0,
        PICKABLE = ( 1 << 0 ),
        VISIBLE = ( 1 << 1 ),
        MUTABLE_TRANSFORM = ( 1 << 2 ),
        MUTABLE_VERTICES = ( 1 << 3 ),

        // PARTICLE_TEMPLATE is used to add display geometry which can be shared by many particles.
        // Special rules apply to geometries created with this flag:
        // - You cannot call addGeometryInstance or updateGeometryTransform
        // - Instead, you call updateParticleTransforms, which simultaneously sets the number of instances
        //   and all of their colors and transforms
        // - Before removing the geometry, you must first use updateParticleTransforms to zero the instance count
        PARTICLE_TEMPLATE = ( 1 << 4 ),

        DEFAULT = ( PICKABLE | VISIBLE | MUTABLE_TRANSFORM ),
        DEFAULT_FIXED = ( PICKABLE | VISIBLE ),
    };

    HK_DECLARE_FLAGS_EX_CLASS( hkDisplayGeometryFlags, hkDisplayGeometryFlags::Bits );
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
