// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

inline hkDisplayGeometry::hkDisplayGeometry(hkDisplayGeometryType type)
:   m_geometry(HK_NULL),
    m_type(type)
{
    m_transform.setIdentity();
}

_Ret_ const hkGeometry* hkDisplayGeometry::getGeometry() const
{
    return m_geometry;
}

_Ret_ hkGeometry* hkDisplayGeometry::getGeometry()
{
    return m_geometry;
}

inline const hkTransform& hkDisplayGeometry::getTransform() const
{
    return m_transform;
}

inline void hkDisplayGeometry::setTransform( const hkTransform& transform )
{
    HK_ASSERT( 0xb37ae889, ( m_type != HK_DISPLAY_AABB ) && ( m_type != HK_DISPLAY_CONE ) && ( m_type != HK_DISPLAY_SEMICIRCLE ) && ( m_type != HK_DISPLAY_PLANE ), "This display shape does not permit a non-identity transform." );
    m_transform = transform;
}

inline void hkDisplayGeometry::setTranslation( const hkVector4& translation )
{
    HK_ASSERT( 0xb37ae889, ( m_type != HK_DISPLAY_AABB ) && ( m_type != HK_DISPLAY_CONE ) && ( m_type != HK_DISPLAY_SEMICIRCLE ) && ( m_type != HK_DISPLAY_PLANE ), "This display shape does not permit a non-identity transform." );
    m_transform.setTranslation( translation );
}

inline hkDisplayGeometryType hkDisplayGeometry::getType() const
{
    return m_type;
}

inline void hkDisplayGeometry::releaseGeometry()
{
    m_geometry = HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
